#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

""" Setup.py script """

from setuptools import setup
from setuptools.command.install import install
from shutil import copy
import os

VERSION = "0.1.6"

INSTALL_REQS = ["argparse", "phase.currentcost", "phase.timeserieslogger"]

PROJECT = "phase"


class CustomInstall(install):  # pylint: disable=W0232
    """Add custom installation after pip install.

    """

    def run(self):
        """Main method

        """
        install.run(self)
        # Custom installation steps here
        folder_path = os.path.join("/opt", PROJECT)
        log_folder_path = os.path.join("/var", "log", PROJECT)
        supervisor_folder = os.path.join(
            "/etc", "supervisor", "conf.d", PROJECT)
        log_conf_path = os.path.join("logs", "%s.conf" % (PROJECT))
        supervisor_currentcost_path = os.path.join(
            "supervisor", "phase.currentcost.conf")
        supervisor_timeserieslogger_path = os.path.join(
            "supervisor", "phase.timeserieslogger.conf")
        if not os.path.exists(folder_path):
            os.makedirs(folder_path)
        if not os.path.exists(log_folder_path):
            os.makedirs(log_folder_path)
        copy(log_conf_path, folder_path)
        copy(supervisor_currentcost_path, supervisor_folder)
        copy(supervisor_timeserieslogger_path, supervisor_folder)


setup(
    name="%s" % (PROJECT),
    version=VERSION,
    description="Python Home Automation project",
    long_description=open('README.rst').read(),
    author="Pierre Leray",
    author_email="pierreleray64@gmail.com",
    url="https://github.com/liogen/%s" % (PROJECT),
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Operating System :: Unix",
        "Programming Language :: Python :: 2.7",
        "Topic :: Home Automation",
        "License :: OSI Approved :: MIT License",
    ],
    packages=[PROJECT],
    scripts=["bin/%s" % (PROJECT)],
    install_requires=INSTALL_REQS,
    zip_safe=False,
    cmdclass={'install': CustomInstall},
)
