#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

"""Globals and function needs for this project.

.. module:: utils
    :platform: Unix
    :synopsis: This module contains all useful globals and function needed.

.. moduleauthor:: Pierre Leray <pierreleray64@gmail.com>

"""

import argparse
import logging
from datetime import datetime

# Logger initialization
LOGGER = logging.getLogger("currentcost")


def argument_parser():
    """Method that parse arguments from command line, return an error in
    case of missing parameter or return arguments with their value.

    :returns:  dict -- Dict containing arguments.

    """
    # Get command line arguments
    parser = argparse.ArgumentParser()
    # Define expected arguments
    parser.add_argument("command", help="Command method (start or stop)")
    parser.add_argument("-v", "--verbose", help="activate verbose mode",
                        action="store_true")
    # Return list of argument passed in command line
    return parser.parse_args()


def init_message(log_conf):
    """Create log message at script starting.

    :param log_conf: Path to log configuration.
    :type log_conf: str.
    """
    # Create init message
    message = "Starting phase application\n"
    message += "Current time: %s\n" % datetime.now()
    message += "Log configuration: %s\n" % log_conf
    # We log this message
    LOGGER.info(message)


def verbose_mode(verbose):
    """Active verbose mode.

    :param verbose: Boolean if true active verbose mode.
    :type device_id: bool.

    """
    # If verbose mode is activated
    if verbose:
        # Create an handler to console and display log message
        sth = logging.StreamHandler()
        sth.setLevel(logging.INFO)
        # Add this handler to current logger
        LOGGER.addHandler(sth)
