
class Git(object):
    def __init__(self, sh, local=None, remote=None, verbose=True):

        super().__init__()

        from ..util.system import notify

        if hasattr(sh, '__call__'): self.sh = sh
        else: notify('could not load git tool', state=True, more=str(type(sh)))

        self.__local = local
        self.__remote = remote

        self.__verbose = verbose

        self.sh(
            'git tool startup done',
            cmd=None,
            cin=dict(local=local, remote=remote),
            sh_verb=False
        )


    @property
    def local(self):
        return self.__local

    @local.setter
    def local(self, path):
        if path: self.__local = path

    def _is_git(self):
        c = self.sh(
            '%s _is_git - runs a git command inside local folder and checks for the returncode' %(__name__),
            'git -C %s log -n 0' %(self.__local),
            critical=False,
            sh_verb=False
        )
        return c.get('returncode', False) == 0
