
from setuptools import setup
from os import path as _path
from info import pkg_name, release, url, __author, __email, __doc__ as __setup_doc__

__long_desc = __setup_doc__
with open(_path.join(_path.dirname(_path.abspath(__file__)), 'Readme.rst'), 'r') as readme:
    __long_desc = readme.read() + __setup_doc__

setup(
    name=pkg_name(),
    version=release(),
    url=url(),
    download_url='%sarchive/%s.tar.gz' %(url(), release()),
    license='BSD',
    author=__author(),
    author_email=__email(),
    description=__setup_doc__,
    long_description=__long_desc,
    packages=['photon', 'photon.util', 'photon.tools'],
    include_package_data=True,
    zip_safe=False,
    platforms='posix',
    scripts=['photon_settings_shell.py'],
    provides=[pkg_name()],
    requires=['PyYAML (>=3.11)'],
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Environment :: Console',
        'Environment :: No Input/Output (Daemon)',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'Intended Audience :: Telecommunications Industry',
        'License :: OSI Approved :: BSD License',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: System :: Networking',
        'Topic :: System :: Systems Administration',
    ],
)
