#!/usr/bin/env python

import setuptools

setuptools.setup(
        name = 'photosort',
        version = '2013.3',
        description = 'Picture inbox simplified',
        author = 'Miguel Angel Ajo Pelayo',
        author_email = 'miguelangel@ajo.es',
        url = 'https://github.com/mangelajo/photosort',
        packages = setuptools.find_packages(exclude = ['ez_setup']),
        include_package_data = True,
        zip_safe = False,
        entry_points = {
            'console_scripts': [
                'photosort = photosort.photosort:main'
            ]},
        install_requires = ['pyaml', 'PIL'],
        package_data={"photosort": ['photosort/test/data/etc/*',
                                    'photosort/test/data/media1/*']},
        test_suite = 'photosort.test.testcases',
        license = 'GPLv3',
        long_description=open('README.md').read(),
        )



