#!/usr/bin/env python

import setuptools

setuptools.setup(
        name = 'photosort',
        version = '2013.7',
        description = 'Picture inbox simplified',
        author = 'Miguel Angel Ajo Pelayo',
        author_email = 'miguelangel@ajo.es',
        url = 'https://github.com/mangelajo/photosort',
        packages = setuptools.find_packages(exclude = ['ez_setup']),
        include_package_data = True,
        zip_safe = False,
        entry_points = {
            'console_scripts': [
                'photosort = photosort.photosort:main'
            ]},
        install_requires = ['pyaml', 'PIL'],
        package_data={"photosort": ['photosort/test/data/etc/*',
                                    'photosort/test/data/media1/*']},
        test_suite = 'photosort.test.testcases',
        license = 'GPLv3',
        long_description="""PhotoSort simplifies your photo inbox, it watches for a set of photo
            input directories, to catalog and move into a predefined storage,
            it can delete the input or keep it.

            It does take care of duplicate files, if there is a duplicate in a
            it will be moved to the duplicates directory""",
        )



