# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



# ----------------------------------------------------------------------------
# TellStick Duo  additionnal functions
# with Python 2.7.x  and 3.x
# ----------------------------------------------------------------------------
# Company Telldus Technologies
# ----------------------------
# - Website: http://www.telldus.com
# - Documentation and source code TellStick Duo is used as base for development of scripts
# ----------------------------------------------------------------------------


import logging

logger = logging.getLogger()

RequestCmd = {
   'STAT':([0x56,0x2B],b'',5,'Status : Version request "V+"'),
   'VERS':([0x56,0x2B],b'',5,'Version request  "V+"'),
   }



def requestcmd(dev,rcmd):
    if rcmd in RequestCmd:
        seq, ack, lenresp, msg = RequestCmd[rcmd]
        logger.debug("Request %s to controller...",msg)
        dev.write(seq[0])
        r = None
        if seq[1] != b'':
            dev.write(seq[1])
        if ack != b'':
            r = dev.read(1)
            logger.debug("Ack %s - Read %s",ack,r)
        if lenresp > 1:
            n = 0
            while n < 5:
                res = dev.read(lenresp)
                if not res:
                    n += 1
            return res
        return r
    return None

