# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



# ----------------------------------------------------------------------------
# RFXCom 433 receiver additionnal functions
# Python version 2.7.x and 3.x
# ----------------------------------------------------------------------------
# Software HEYU
# -------------
# - Website: http://www.heyu.org
# - HEYU is used as base for development of scripts
#
# Software AnyEvent-RFXCOM
# ------------------------
# - Website: http://search.cpan.org/dist/AnyEvent-RFXCOM/
# - AnyEvent-RFXCOM is used as base for development of scripts
# ----------------------------------------------------------------------------


import logging

logger = logging.getLogger()

RequestCmd = {
   'STAT':(['0xF0','0x20'],'',4,'Status : Version request'),
   'VERS':(['0xF0','0x20'],'',4,'Version request'),
   'ALLR':(['0xF0','0x2A'],'0x2c',1,'Enable all receiving modes'),
   'VARL':(['0xF0','0x2C'],'0x2c',1,'Enable variable length'),
   'ARCT':(['0xF0','0x2D'],'0x2c',1,'Disable Arctech'),
   'X10S':(['0xF0','0x2F'],'0x2c',1,'Disable X10 standard'),
   'KOPP':(['0xF0','0x2E'],'0x2c',1,'Disable Koppla'),
   'HEUK':(['0xF0','0x28'],'0x2c',1,'Disable HomeEasy_UK'),
   'OREG':(['0xF0','0x43'],'0x2c',1,'Disable Oregon'),
   'ATIW':(['0xF0','0x44'],'0x2c',1,'Disable ATI Wonder'),
   'VARV':(['0xF0','0x45'],'0x2c',1,'Disable Visonic'),
   'HEEU':(['0xF0','0x47'],'0x2c',1,'Disable HomeEasy_EU'),
   }
  
#   'W800':(['0xF0','0x29'],'0x29',1,'Enable mode W800 compatibility'),



def requestcmd(dev,rcmd):
    if rcmd in RequestCmd:
        seq, ack, lenresp, msg = RequestCmd[rcmd]
        logger.debug("Request %s to controller...",msg)
        dev.write(seq[0])
        r = None
        if seq[1] != '':
            dev.write(seq[1])
        if ack != '':
            r = dev.readh()
            logger.debug("Ack %s - Read %s",ack,r)
        if lenresp > 1:
            res = []
            for i in range(0,lenresp):
                res.append(dev.readh())
            return res
        return r
    return None
