# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# Menus for use piHAcontrollers
# Python 2.7 and 3.x
# Use module argparse
# ----------------------------------------------------------------------------

import argparse
from .piHAmfct import *



def maincheck():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d','--debug', action='store_true')
    parser.add_argument('-c','--checkreq', action='store_true')
    parser.add_argument('-m','--checkmod', action='store_true')
    parser.add_argument('-u','--controllers', action='store_true')
    return vars(parser.parse_args())



def mainctrl():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d','--debug', action='store_true')
    parser.add_argument('-f','--evtfile', default='rxevents.log')
    parser.add_argument('-l','--log', action='store_true')
    parser.add_argument('-s','--status', action='store_true')
    subparsers = parser.add_subparsers(dest='controller',help='sub-command help')

    p_atir = subparsers.add_parser('atir')
    p_atir.set_defaults(c_init=f_atir)
    p_atir.add_argument('-r','--rxtcp', action='store_true')

    p_cm11 = subparsers.add_parser('cm11')
    p_cm11.add_argument('-p','--port', default='/dev/ttyUSB0')
    p_cm11.set_defaults(c_init=f_cm11)
    g_cm11 = p_cm11.add_mutually_exclusive_group()
    g_cm11.add_argument('-r','--rxtcp', action='store_true')

    p_cm15 = subparsers.add_parser('cm15')
    p_cm15.set_defaults(c_init=f_cm15)
    g_cm15 = p_cm15.add_mutually_exclusive_group()
    g_cm15.add_argument('-r','--rxtcp', action='store_true')

    p_irecv = subparsers.add_parser('irecv')
    p_irecv.set_defaults(c_init=f_irecv)
    p_irecv.add_argument('-r','--rxtcp', action='store_true')

    p_rfxcom = subparsers.add_parser('rfxcom')
    p_rfxcom.add_argument('-p','--port', default='/dev/ttyUSB0')
    p_rfxcom.set_defaults(c_init=f_rfxcom)
    p_rfxcom.add_argument('-r','--rxtcp', action='store_true')

    p_rfxtrx = subparsers.add_parser('rfxtrx')
    p_rfxtrx.add_argument('-p','--port', default='/dev/ttyUSB0')
    p_rfxtrx.set_defaults(c_init=f_rfxtrx)
    g_rfxtrx = p_rfxtrx.add_mutually_exclusive_group()
    g_rfxtrx.add_argument('-r','--rxtcp', action='store_true')

    p_tsduo = subparsers.add_parser('tsduo')
    p_tsduo.set_defaults(c_init=f_tsduo)
    g_tsduo = p_tsduo.add_mutually_exclusive_group()
    g_tsduo.add_argument('-r','--rxtcp', action='store_true')

    p_tsduo1 = subparsers.add_parser('tsduo1')
    p_tsduo1.set_defaults(c_init=f_tsduo1)
    g_tsduo1 = p_tsduo1.add_mutually_exclusive_group()
    g_tsduo1.add_argument('-r','--rxtcp', action='store_true')

    return vars(parser.parse_args())




def maindev():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d','--debug', action='store_true')
    parser.add_argument('-a','--checkall', action='store_true')
    group = parser.add_mutually_exclusive_group()
    group.add_argument('-v','--verify', action='store_true')
    group.add_argument('-r','--read', action='store_true')
    subparsers = parser.add_subparsers(dest='controller', help='sub-command help')
    p_all = subparsers.add_parser('all')
    p_all.add_argument('-v','--checkall', action='store_true')
    p_ftdi = subparsers.add_parser('ftdi')
    p_ftdi.add_argument('-i','--vidpid', default='1781:0c31')
    p_ftdi.set_defaults(c_init=f_ftdi)
    p_serial = subparsers.add_parser('serial')
    p_serial.add_argument('-p','--port', default='/dev/ttyUSB0')
    p_serial.set_defaults(c_init=f_serial)
    p_usb = subparsers.add_parser('usb')
    p_usb.add_argument('-i','--vidpid', default='0BC7:0001')
    p_usb.set_defaults(c_init=f_usb)
    return vars(parser.parse_args())



if __name__ == "__main__":
    print (mainctrl())
