# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,datetime
from functools import wraps
from .sqlitedb import (majdb3,fieldsdb3)

logger = logging.getLogger()

def coroutine(func):
    def start(*args,**kwargs):
        cr = func(*args,**kwargs)
        next(cr)
        return cr
    return start

def my_fctname(f):
    @wraps(f)
    def wrapper(*args, **kwds):
        return f(*args, **kwds)
    return wrapper


@coroutine
def broadcast(targets):
    while True:
        line = (yield)
        for target in targets:
            target.send(line)


@my_fctname
@coroutine
def debug():
    while True:
        msg = (yield)
        logger.debug(repr(msg))


@coroutine
def log2file(logfile,sep=" "):
    while True:
       	msg = (yield)
        line = sep.join([str(i) for i in msg])
        try:
            wf = open(logfile,'ab')
            wf.write((line + "\n").encode('utf-8'))
            wf.close()
        except Exception as e:
           logger.error("%s : %s", repr(e.__class__), str(e))


@coroutine
def log2db():
    while True:
        item = (yield)
        fields = fieldsdb3('decodedevents')
        req = 'INSERT INTO decodedevents('
        V = ' VALUES ('
        for i in range(0,len(item)):
            req += fields[i+1] + ','
            V += '?,'
        V = V[:-1] + ');'
        req = req[:-1] + ') ' + V
        majdb3(req,item)


@coroutine
def multievtqueue(mcrx=None):
    while True:
        evt = (yield)
        if mcrx:
            mcrx.multievtq.put_nowait(evt)
        else:
            print (repr(evt))


@coroutine
def printer():
    while True:
        msg = (yield)
        print (repr(msg))


@coroutine
def unduplicate(target,ellapse=10):
    lastevt = None
    lasttime = datetime.datetime.today()
    while True:
        event = (yield)
        now = datetime.datetime.today()            
        if event == lastevt:
            t = lasttime + datetime.timedelta(seconds=ellapse)
            if t > now:
                logger.debug("Event in repeat delay")
                lasttime = now
                continue
        target.send(event)
        lastevt = event
        lasttime = now
