# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



# ----------------------------------------------------------------------------
# Script for devices and controllers
# with serial interface
# Require python-serial version >= 2.5
# Feature findports need python-serial version >= 2.6
# Python version 2.7.x and 3.x
# ----------------------------------------------------------------------------
# pySerial
# --------
# - Website: http://pyserial.sourceforge.net/
# - Documentation and source code pySerial is used as base for development
# ----------------------------------------------------------------------------


import logging,serial

logger = logging.getLogger()

def findports():
    try:
        import serial.tools.list_ports
    except ImportError:
        logger.critical("Version < 2.5 of PySerial do not have find port function")
        return None
    ports = serial.tools.list_ports.comports()
    for p in ports:
        logger.info("Possible ports %s :", repr(p))
        if 'ttyUSB' in p[0]:
            logger.info("Perhaps use port ttyUSB %s :", repr(p))
            return p
        else:
            logger.critical("Unable to find a valuable port")
            return None
    logger.warning("Trying to use the first port %s",repr(ports[0]))
    return ports[0]

