# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# Menus for use piHAcontrollers
# Python 2.6 and 2.7
# Use module optparse (deprecated since 2.7)
# Use script pyHAmarg.py instead
# ----------------------------------------------------------------------------

from  optparse import OptionParser
from .piHAmfct import *

c_fcts =  {
          'atir':f_atir,
          'cm11':f_cm11,
          'cm15':f_cm15,
          'irecv':f_irecv,
          'rfxcom':f_rfxcom,
          'rfxtrx':f_rfxtrx,
          'tsduo':f_tsduo,
          'tsduo1':f_tsduo1,
          'ftdi':f_ftdi,
          'serial':f_serial,
          'usb':f_usb,
          }



def maincheck():
    parser = OptionParser(usage='usage: %prog [options] ')
    parser.add_option('-d','--debug', action='store_true')
    parser.add_option('-c','--checkreq', action='store_true')
    parser.add_option('-m','--checkmod', action='store_true')
    parser.add_option('-u','--controllers', action='store_true')
    (options, args) = parser.parse_args()
    rargs = vars(options)
    return rargs


def mainctrl():
    parser = OptionParser(usage='usage: %prog [options] ')
    parser.add_option('-c', '--controller',
                      type='choice',
                      action='store',
                      dest='controller',
                      choices=['atir', 'cm11', 'cm15', 'irecv', 'rfxcom', 'rfxtrx', 'tsduo', 'tsduo1'],
                      default='rfxcom',
                      help='Controller to use for listen to incoming events',)
    parser.add_option('-d','--debug', default=False, action='store_true')
    parser.add_option('-f','--evtfile', default='rxevents.log')
    parser.add_option('-l','--log', default=False, action='store_true')
    parser.add_option('-s','--status', default=False, action='store_true')
    parser.add_option('-r','--rxtcp', default=False, action='store_true')
    parser.add_option('-p','--port', default='/dev/ttyUSB0')

    (options, args) = parser.parse_args()
    rargs = vars(options)
    rargs.setdefault('c_init')
    rargs['c_init'] = c_fcts[rargs['controller']]
    return rargs


def maindev():
    parser = OptionParser(usage='usage: %prog [options] ')
    parser.add_option('-c', '--controller',
                      type='choice',
                      action='store',
                      dest='controller',
                      choices=['ftdi','serial','usb'],
                      default='serial',
                      help='Interface of controller to use',)
    parser.add_option('-a','--checkall', default=False, action='store_true')
    parser.add_option('-d','--debug', default=False, action='store_true')
    parser.add_option('-v','--verify', default=False, action='store_true')
    parser.add_option('-r','--read', default=False, action='store_true')
    parser.add_option('-p','--port', default='/dev/ttyUSB0')
    parser.add_option('-i','--vidpid', default='1781:0c31')

    (options, args) = parser.parse_args()
    rargs = vars(options)
    rargs.setdefault('c_init')
    rargs['c_init'] = c_fcts[rargs['controller']]
    return rargs



if __name__ == "__main__":
    rargs = mainctrl()
    print (repr(rargs))