# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



import logging

logger = logging.getLogger()

Controllers = {}

FTDIControllerIds ={
     '0403:6001':'FTDI USB-Serial adapter for Serial controller',
     '1781:0c31':'FTDI USB device',
     }

USBControllerIds = {
     '0bc7:0004':'ATI Remote Wonder X10 Wireless USB receiver',
     '0bc7:0001':'CM15a X10 Powerline and Wireless USB controller',
     '147a:e03e':'IR IR605A/Q USB receiver',
     '0403:6001':'FTDI USB-Serial adapter for Serial controller',
     '1a86:7523':'HL-340 USB-Serial adapter',
     }


try:
    from atir import ATIR
    Controllers.setdefault('ATIR')
    Controllers['ATIR'] = ATIR
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from cm11 import CM11
    Controllers.setdefault('CM11')
    Controllers['CM11'] = CM11
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from cm15 import CM15
    Controllers.setdefault('CM15')
    Controllers['CM15'] = CM15
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from rfxcom import RFXCOM
    Controllers.setdefault('RFXCOM')
    Controllers['RFXCOM'] = RFXCOM
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from rfxtrx import RFXTRX
    Controllers.setdefault('RFXTRX')
    Controllers['RFXTRX'] = RFXTRX
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from tsduo import TSDUO
    Controllers.setdefault('TSDUO')
    Controllers['TSDUO'] = TSDUO
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

if 'TSDUO' not in Controllers:
    try:
        from tsduo1 import TSDUO
        Controllers.setdefault('TSDUO')
        Controllers['TSDUO'] = TSDUO
    except ImportError as e:
        logger.debug("%s : %s", repr(e.__class__), str(e))
