# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



import logging,SocketServer,sys,threading

logger = logging.getLogger()

if (sys.version_info.major > 2):
    import queue
    INPUTq = queue.Queue()
else:
    import queue
    INPUTq = Queue.Queue()

from  .commonlibs import (addr2host)


class TCPCMDHandler(SocketServer.StreamRequestHandler):
    def handle(self):
        data = self.rfile.readline().strip()
        print "{} wrote:".format(self.client_address[0])
        print data
        INPUTq.put_nowait(data)
        self.wfile.write('Parsing input ...')

class TCPTXServer(SocketServer.ThreadingTCPServer):
    def __init__(self,addr=None):
        self.host,self.port = addr2host(defaddr=('localhost','9000'),addr=addr)
        self.handler = TCPCMDHandler
        self.allow_reuse_address
        self.type = 'SRV'
        self.name = 'TCPTXServer'
        self.cmdnetq = INPUTq
        self.servercmds = {'STARTS':self.starts,'STOPS':self.stops}

    def starts(self):
        tt = threading.Thread(target=self.serve)
        tt.name = 'TCPTXServer_' + self.name
        tt.daemon = True
        tt.start()
        print ('TCPTXServer started and active...')
 
    def tsetup(self):
        SocketServer.ThreadingTCPServer.__init__(self, (self.host, self.port), self.handler)
        self.setup = True

    def serve(self):
        print ('Listening at address %s on port number %s...\n' % (self.host, self.port))
        self.serve_forever()

    def stops(self):
        self.shutdown()
        print ('TCPTXServer shutting down...')

