# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



import datetime,logging,logging.handlers,time

logger = logging.getLogger()

def addr2host(defaddr,addr=None):
    """
    defaddr=('localhost','9000')
    """
    if addr :
       host,port = addr
    else:
       host,port = None,None
    if host is None:
       host = defaddr[0]
    if port:
       port = int(port)
    else:
       port = int(defaddr[1])
    return host,port


def log2console():
    logger = logging.getLogger()
    hdlr = logging.StreamHandler() # Console
    formatter = logging.Formatter('%(module)s - %(asctime)s %(levelname)s %(message)s')
    hdlr.setFormatter(formatter)
    logger.addHandler(hdlr)


def rxeventlog(dev,logfile=None,socket=False,defaddr=('localhost','9020')):
    """
    Write event into logfile or to socket
    Write a line for each event
    Input event : a string of sequence of hex
    """
    if not dev.setup: return True
    if logfile:
        filehdlr = logging.FileHandler(logfile)
        formatterf = logging.Formatter('%(module)s - %(asctime)s %(levelname)s %(message)s')
        filehdlr.setFormatter(formatterf)
        logger.addHandler(filehdlr)
    elif socket:
        host,port = addr2host(defaddr)
        socketh = logging.handlers.SocketHandler(host,port)
        logger.addHandler(socketh)
    logger.setLevel(logging.DEBUG)
    while True:
        data = dev.rxevent()
        if data:
           logger.info("%s", data)


def rxeventq(dev,evtq):
    """
    Write event to Queue
    Write a line for each event
    Input event : a string of sequence of hex
    """
    if not dev.setup: return
    while True:
        data = dev.rxevent()
        if data:
            evtq.put_nowait(data)
