# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



# ----------------------------------------------------------------------------
# Use to receive RF events
# from TellStick Duo interface
# Receiving data / USB FTDI Serial
# Require pylibftdi from https://pypi.python.org/pypi/pylibftdi/
# with Python 2.7.x and 3.x
# ----------------------------------------------------------------------------
# Company Telldus Technologies
# ----------------------------
# - Website: http://www.telldus.com
# - Documentation and source code TellStick Duo is used as base for development of scripts
# ----------------------------------------------------------------------------


import logging
from pylibftdi import USB_PID_LIST, USB_VID_LIST, Device
from .ctrlfcts.tsduofct import (requestcmd)


logger = logging.getLogger()


class TSDUO(Device):

    def __init__(self,port=None,_id=None):
        USB_VID_LIST.append(0x1781)
        USB_PID_LIST.append(0x0c31)
        self.idcontroller = 'TSDUO'
        self.opened = False
        self.setup = False
        self.TXcap = True
        self.RXcap = True
        try:
            Device.__init__(self,'A6028C22',mode='b',encoding='latin1')
            self.opened = True
        except Exception as e:
            logger.critical("%s : %s", repr(e.__class__), str(e))
            self.port = 'PortUnavailable'
            return

    def tsetup(self):
        """
        Setup interface with request version test
        """
        if not self.opened: return
        logger.debug("Starting %s with version request....",self.idcontroller)
        try:
            self.flush()
        except Exception as e:
            logger.critical("%s : %s", repr(e.__class__), str(e))
            self.port = 'PortUnavailable'
            return
        data = self.request('VERS')
        logger.debug("Result %s...",repr(data))
        logger.warning("%s Ready....",self.idcontroller)
        self.setup = True
        self.device = self.idcontroller + '-ftdiport'


    def flush(self):
        logger.debug("Flush interface buffer %s...",self.idcontroller)
        n = 0
        res = None
        while n < 5:
            res = self.read(100)
            if not res:
                n += 1
        return res

    def request(self,rcmd):
        return requestcmd(self,rcmd)

    def plsend(self):
        return None

    def rfsend(self,data,msgq=None):
        databytes = [ord(i) for i in data]
        for byte in databytes:
            self.write(byte)
        res = self.read(5)
        logger.debug("Result %s...",repr(res))
        return res

    def rxevent(self,maxlen=100):
        """
        Read one event after flush/pause
        Cut down data
        and eliminates same events
        """
        data = self.read(maxlen)
        if not data :
            return None
        events = []
        n = data.count('+W')
        if n == 0 :
            return None
        a = data.split(";\r\n")[0]            
        first = a[2:]
        if n == 1:
            events.append(first)
            return events
        else:
            next = self.read(10 * maxlen)
            if not next: return events
            n1 = next.count('+W')
            data += next
            n += n1
            evts = data.split(";\r\n")
            for a in evts[1:-1]:
                 e = a[2:]
                 if e not in events:
                      events.append(e)
            logger.warning("Cut down data into %s fragments with %s different events",str(n),str(len(events)))
            return events
