#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.3 on Wed Jun 30 23:06:46 2010

import wx
from pieberry_validators import *
from pieberry_config import *
from pieberry_exec import wxdate2pydate
from utility.bibtex import *
import time
# begin wxGlade: extracode
# end wxGlade



class pieBibEditDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: pieBibEditDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.panel_4 = wx.Panel(self, -1)
        self.panelx = wx.Panel(self, -1, style=wx.NO_BORDER|wx.TAB_TRAVERSAL)
        self.label_a = wx.StaticText(self.panelx, -1, "BibTeX key")
        self.keyCtrl = wx.TextCtrl(self.panelx, -1, "", validator=pieBibtexValidator())
        self.keyAutoCb = wx.CheckBox(self.panelx, -1, label="Auto-generate")
        self.label_3 = wx.StaticText(self.panelx, -1, "Author:", style=wx.EXPAND)
        self.authorIsCorporateCb = wx.CheckBox(self.panelx, -1, label="Author is corporate entity", style=wx.CHK_3STATE|wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.authorCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_PROCESS_ENTER, validator=pieBibtexValidator())
        self.authorSwapButton = wx.BitmapButton(self.panelx, -1, wx.ArtProvider.GetBitmap(wx.ART_GO_BACK, wx.ART_TOOLBAR, (16, 16)))
        self.authorAltCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_READONLY)

        self.label_4 = wx.StaticText(self.panelx, -1, "Title:")
        self.titleCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_PROCESS_ENTER|wx.EXPAND, validator=pieBibtexValidator())
        self.titleSwapButton = wx.BitmapButton(self.panelx, -1, wx.ArtProvider.GetBitmap(wx.ART_GO_BACK, wx.ART_TOOLBAR, (16, 16)))
        self.titleAltCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_READONLY)


        self.label_5 = wx.StaticText(self.panelx, -1, "Date of publication:")
        self.datePicker = wx.DatePickerCtrl(self.panelx, -1)
        self.label_6 = wx.StaticText(self.panelx, -1, "How published:")
        self.howpublishedCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_PROCESS_ENTER, validator=pieBibtexValidator())
        self.label_7 = wx.StaticText(self.panelx, -1, "Note:")
        self.noteCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_MULTILINE, validator=pieBibtexValidator())
        self.label_8 = wx.StaticText(self.panelx, -1, "Annotation:")
        self.annoteCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_MULTILINE, validator=pieBibtexValidator())
        self.btCancel = wx.Button(self.panel_4, wx.ID_CANCEL, "Cancel")
        self.btOk = wx.Button(self.panel_4, -1, "Ok")


        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onCancel, self.btCancel)
        self.Bind(wx.EVT_BUTTON, self.onOk, self.btOk)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: pieBibEditDialog.__set_properties
        self.SetTitle("Edit Bibliography Entry")
        self.SetSize((547, 558))
        self.panel_4.SetMinSize((55, 35))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: pieBibEditDialog.__do_layout
        sizer_7 = wx.BoxSizer(wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_A = wx.BoxSizer(wx.HORIZONTAL)
        sizer_B = wx.BoxSizer(wx.HORIZONTAL)
        sizer_C = wx.BoxSizer(wx.HORIZONTAL)
        sizer_D = wx.BoxSizer(wx.HORIZONTAL)
        sizer_A.Add(self.label_a, 0, wx.ALL, 3)
        sizer_A.Add(self.keyCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_A.Add(self.keyAutoCb, 1, wx.ALL, 3)
        sizer_9.Add(sizer_A, 0, wx.EXPAND)
        sizer_9.Add(wx.StaticLine(self.panelx, style=wx.LI_HORIZONTAL|wx.EXPAND))
        sizer_D.Add(self.label_3, 1, wx.ALL, 3)
        sizer_D.Add(self.authorIsCorporateCb, 0, wx.ALL, 3)
        sizer_9.Add(sizer_D, 0, wx.EXPAND)
        sizer_B.Add(self.authorCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_B.Add(self.authorSwapButton, 0, wx.ALL, 3)
        sizer_B.Add(self.authorAltCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_9.Add(sizer_B, 0, wx.EXPAND)
        sizer_9.Add(self.label_4, 0, wx.ALL, 3)
        sizer_C.Add(self.titleCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_C.Add(self.titleSwapButton, 0, wx.ALL, 3)
        sizer_C.Add(self.titleAltCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_9.Add(sizer_C, 0, wx.EXPAND)
        sizer_9.Add(self.label_5, 0, wx.ALL, 3)
        sizer_9.Add(self.datePicker, 0, wx.ALL, 3)
        sizer_9.Add(self.label_6, 0, wx.ALL, 3)
        sizer_9.Add(self.howpublishedCtrl, 0, wx.ALL|wx.EXPAND, 3)
        sizer_9.Add(self.label_7, 0, 0, 0)
        sizer_9.Add(self.noteCtrl, 1, wx.ALL|wx.EXPAND, 3)
        sizer_9.Add(self.label_8, 0, 0, 0)
        sizer_9.Add(self.annoteCtrl, 1, wx.ALL|wx.EXPAND, 3)
        self.panelx.SetSizer(sizer_9)
        sizer_7.Add(self.panelx, 6, wx.ALL|wx.EXPAND, 3)
        sizer_8.Add((20, 20), 3, wx.EXPAND, 0)
        sizer_8.Add(self.btCancel, 0, wx.ALL, 3)
        sizer_8.Add(self.btOk, 0, wx.ALL, 3)
        self.panel_4.SetSizer(sizer_8)
        sizer_7.Add(self.panel_4, 0, wx.EXPAND, 0)
        self.SetSizer(sizer_7)
        self.Layout()
        # end wxGlade

    def onCancel(self, event): # wxGlade: pieBibEditDialog.<event_handler>
        print "Event handler `onCancel' not implemented!"
        event.Skip()

    def onOk(self, event): # wxGlade: pieBibEditDialog.<event_handler>
        print "Event handler `onOk' not implemented!"
        event.Skip()

# end of class pieBibEditDialog


class pieConfigDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: pieConfigDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.panel_2 = wx.Panel(self, -1)
        self.panel_1 = wx.Panel(self, -1)
        self.label_1 = wx.StaticText(self.panel_1, -1, "Root directory for library:")
        self.workDirCtrl = wx.TextCtrl(self.panel_1, -1, "", style=wx.TE_READONLY)
        self.workDirBt = wx.Button(self.panel_1, -1, "Select")
        self.label_2 = wx.StaticText(self.panel_1, -1, "Principal bibliography file:")
        self.mainBibCtrl = wx.TextCtrl(self.panel_1, -1, "", style=wx.TE_READONLY)
        self.mainBibBt = wx.Button(self.panel_1, -1, "Select")
        self.tsvBibCb = wx.CheckBox(self.panel_1, -1, label='Also export to tab-separated-values spreadsheet')
        self.defaultEntryTypeChoice = wx.Choice(self.panel_1, -1, choices=ENTRY_TYPE_CHOICES.values())
        self.okBt = wx.Button(self.panel_2, -1, "Ok")
        self.cancelBt = wx.Button(self.panel_2, wx.ID_CANCEL, "Cancel")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onSelectRoot, self.workDirBt)
        self.Bind(wx.EVT_BUTTON, self.onSelectBib, self.mainBibBt)
        self.Bind(wx.EVT_BUTTON, self.onOk, self.okBt)
        self.Bind(wx.EVT_BUTTON, self.onCancel, self.cancelBt)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: pieConfigDialog.__set_properties
        self.SetTitle("Pieberry Settings")
        self.panel_2.SetMinSize((532, 34))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: pieConfigDialog.__do_layout
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4.Add(self.label_1, 0, wx.ALL, 5)
        sizer_5.Add(self.workDirCtrl, 2, wx.ALL, 5)
        sizer_5.Add(self.workDirBt, 0, wx.ALL, 5)
        sizer_4.Add(sizer_5, 1, wx.EXPAND, 0)
        sizer_4.Add(self.label_2, 0, wx.ALL, 5)
        sizer_6.Add(self.mainBibCtrl, 2, wx.ALL, 5)
        sizer_6.Add(self.mainBibBt, 0, wx.ALL, 5)
        sizer_4.Add(sizer_6, 1, wx.EXPAND, 0)
        sizer_4.Add(self.tsvBibCb, 0, wx.EXPAND|wx.ALL, 5)
        sizer_a = wx.BoxSizer(wx.HORIZONTAL)
        sizer_a.Add(wx.StaticText(self.panel_1, -1, 'Default BibTex style:'), 1, wx.EXPAND|wx.ALL, 5)
        sizer_a.Add(self.defaultEntryTypeChoice, 0, wx.ALL, 5)
        sizer_4.Add(sizer_a, 1, wx.EXPAND, 0)
        self.panel_1.SetSizer(sizer_4)
        sizer_2.Add(self.panel_1, 5, wx.EXPAND, 0)
        sizer_3.Add((20, 20), 3, 0, 0)
        sizer_3.Add(self.cancelBt, 0, wx.ALL, 3)
        sizer_3.Add(self.okBt, 0, wx.ALL, 3)
        sizer_3.Add((5, 5), 0, 0, 0)
        self.panel_2.SetSizer(sizer_3)
        sizer_2.Add(self.panel_2, 0, wx.EXPAND, 0)
        self.SetSizer(sizer_2)
        sizer_2.Fit(self)
        self.Layout()
        # end wxGlade

    def onSelectRoot(self, event): # wxGlade: pieConfigDialog.<event_handler>
        print "Event handler `onSelectRoot' not implemented"
        event.Skip()

    def onSelectBib(self, event): # wxGlade: pieConfigDialog.<event_handler>
        print "Event handler `onSelectBib' not implemented"
        event.Skip()

    def onOk(self, event): # wxGlade: pieConfigDialog.<event_handler>
        print "Event handler `onOk' not implemented"
        event.Skip()

    def onCancel(self, event): # wxGlade: pieConfigDialog.<event_handler>
        print "Event handler `onCancel' not implemented"
        event.Skip()

# end of class pieConfigDialog

class pieFieldPanel(wx.ScrolledWindow):
    def __init__(self, parent, entry_type, fieldlist):
        '''initialise with a string for the type of entry in question,
        and a tuple containing two tuples - (1) strings representing
        compulsory fields for that article type and (2) representing
        optional fields.'''
        wx.ScrolledWindow.__init__(self, parent)
        sizer1 = wx.FlexGridSizer(0, 2, 3, 3)
        sizer1.AddGrowableCol(1)
        # print fieldlist
        for opt_field in fieldlist[0]:
            setattr(self, '%sLabel' % opt_field, wx.StaticText(self, -1, opt_field.capitalize() + ':'))
            setattr(self, '%sCtrl' % opt_field, wx.TextCtrl(self, -1, style=wx.EXPAND, validator=pieBibtexValidator(compulsory=True)))
            a = getattr(self, '%sCtrl' % opt_field)
            a.Bind(wx.EVT_TEXT, parent.GetParent().GetParent().onFieldValidate)
            sizer1.Add(getattr(self, '%sLabel' % opt_field), 0, wx.EXPAND)#, 0, wx.ALL|wx.EXPAND, 3)
            sizer1.Add(a, 1, wx.EXPAND)#, 0, wx.ALL|wx.EXPAND, 3)
        for opt_field in fieldlist[1]:
            setattr(self, '%sLabel' % opt_field, wx.StaticText(self, -1, opt_field.capitalize() + ':'))
            setattr(self, '%sCtrl' % opt_field, wx.TextCtrl(self, -1, style=wx.EXPAND, validator=pieBibtexValidator(compulsory=False)))
            a = getattr(self, '%sCtrl' % opt_field)
            a.SetBackgroundColour('yellow')
            a.Bind(wx.EVT_TEXT, parent.GetParent().GetParent().onFieldValidate)
            sizer1.Add(getattr(self, '%sLabel' % opt_field), 0, wx.EXPAND)#, 0, wx.ALL|wx.EXPAND, 3)
            sizer1.Add(a, 1, wx.EXPAND)#, 0, wx.ALL|wx.EXPAND, 3)
        self.SetSizer(sizer1)
        self.entry_type = entry_type
        self.SetScrollbars(0, 20, 0, 50)
        self.fieldlist = fieldlist

    def getData(self):
        ret = {}
        for it in self.fieldlist[0]:
            f = getattr(self, '%sCtrl' % it)
            if not f.GetValidator().Validate():
                raise Exception, 'Value in %s is inappropriate for BibTeX' % it
            ret[it] = f.GetValue()
        for it in self.fieldlist[1]:
            f = getattr(self, '%sCtrl' % it)
            if not f.GetValidator().Validate():
                raise Exception, 'Value in %s is inappropriate for BibTeX' % it
            if len(f.GetValue()) > 0:
                ret[it] = f.GetValue()
        return self.entry_type, ret

    def setData(self, data):
        for it, val in data.items():
            f = getattr(self, '%sCtrl' % it, None)
            if f:
                f.SetValue(val)



class pieMultiBibEditDialog(wx.Dialog):
    bibtexfields = {
        'article': (
            ('journal',), 
            ('volume', 'number', 'pages', 'note', 'annote')
            ),
        'book': (
            ('publisher',), 
            ('editor', 'volume', 'number', 'series', 'address', 'edition', 'note', 'annote')
            ),
        'misc': (
            ('howpublished',), 
            ('url', 'note', 'annote')
            ),
        'booklet': (
            ('howpublished',), 
            ('note', 'annote')
            ),
        'online': (
            ('howpublished',), 
            ('url', 'note', 'annote')
            ),
        'inbook': (
            ('editor', 'chapter', 'publisher'),
            ('volume', 'number', 'series', 'type', 'address', 'edition', 'pages', 'note', 'annote')
            ),
        'incollection': (
            ('booktitle',),
            ('pages', 'publisher', 'editor', 'volume', 'number', 'series', 'type', 'chapter', 'address', 'edition', 'note', 'annote'),
            ),
        'techreport': (
            ('institution',),
            ('type', 'number', 'address', 'note', 'annote')
            ),
        'unpublished': (
            ('note',),
            ('annote',)
            )
        }
    silentfields = ('pdflink', 'pdflink_context', 'tag', 'outfilename', 'final_fn', 'download_time', 'creation_date_guessed', 'exclude', 'internal_author', 'internal_title')
        
    def __init__(self, bibdata, *args, **kwargs):
        kwargs['style'] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwargs)
        
        self.panelx = wx.Panel(self, -1)

        self.keyCtrl = wx.TextCtrl(self.panelx, -1, "", validator=pieBibtexValidator(compulsory=True))
        self.keyAutoCb = wx.CheckBox(self.panelx, -1, label="Auto-generate")

        self.authorIsCorporateCb = wx.CheckBox(self.panelx, -1, label="Author is corporate entity", style=wx.CHK_3STATE|wx.CHK_ALLOW_3RD_STATE_FOR_USER)
        self.authorCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_PROCESS_ENTER, validator=pieBibtexValidator(compulsory=True))
        self.authorSwapButton = wx.BitmapButton(self.panelx, -1, wx.ArtProvider.GetBitmap(wx.ART_GO_BACK, wx.ART_TOOLBAR, (16, 16)))
        self.authorAltCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_READONLY)
        self.titleCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_PROCESS_ENTER|wx.EXPAND, validator=pieBibtexValidator(compulsory=True))
        self.titleSwapButton = wx.BitmapButton(self.panelx, -1, wx.ArtProvider.GetBitmap(wx.ART_GO_BACK, wx.ART_TOOLBAR, (16, 16)))
        self.titleAltCtrl = wx.TextCtrl(self.panelx, -1, "", style=wx.TE_READONLY)
        self.datePicker = wx.DatePickerCtrl(self.panelx, -1)
        self.choiceBook = wx.Choicebook(self.panelx, -1)
        self.btCancel = wx.Button(self.panelx, wx.ID_CANCEL, "Cancel")
        self.btOk = wx.Button(self.panelx, -1, "Ok")

        self.panelref = []
        for k, v in self.bibtexfields.items():
            pan = pieFieldPanel(self.choiceBook, k, v)
            self.choiceBook.AddPage(pan, k.capitalize())
            self.panelref.append(k)
        self.__set_properties()
        self.__do_layout()
        self.Bind(wx.EVT_BUTTON, self.onCancel, self.btCancel)
        self.Bind(wx.EVT_BUTTON, self.onOk, self.btOk)
        self.authorCtrl.Bind(wx.EVT_TEXT_ENTER, self.onOk)
        self.authorCtrl.Bind(wx.EVT_TEXT, self.onFieldValidate)
        self.titleCtrl.Bind(wx.EVT_TEXT_ENTER, self.onOk)
        self.titleCtrl.Bind(wx.EVT_TEXT, self.onFieldValidate)
        self.keyCtrl.Bind(wx.EVT_TEXT, self.onFieldValidate)
        self.keyAutoCb.Bind(wx.EVT_CHECKBOX, self.onKeygenToggle)
        self.authorSwapButton.Bind(wx.EVT_BUTTON, self.onAuthorSwap)
        self.titleSwapButton.Bind(wx.EVT_BUTTON, self.onTitleSwap)
        self.__fill_fields(bibdata)

    def __set_properties(self):
        self.SetTitle("Edit Bibliography Entry")
        self.SetSize((547, 558))

    def __do_layout(self):
        sizer1 = wx.BoxSizer(wx.VERTICAL)
        sizer2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer3 = wx.BoxSizer(wx.VERTICAL)
        sizer4 = wx.BoxSizer(wx.VERTICAL)

        sizerA = wx.BoxSizer(wx.HORIZONTAL)
        sizerB = wx.BoxSizer(wx.HORIZONTAL)
        sizerC = wx.BoxSizer(wx.HORIZONTAL)
        sizerD = wx.BoxSizer(wx.HORIZONTAL)
        sizerE = wx.BoxSizer(wx.HORIZONTAL)
        sizerF = wx.BoxSizer(wx.HORIZONTAL)


        sizerE.Add(self.keyCtrl, 1, wx.ALL, 3)
        sizerE.Add((22,22), 0, wx.ALL, 3)
        sizerE.Add(self.keyAutoCb, 1, wx.ALL, 3)

        sizerC.Add(wx.StaticText(self.panelx, -1, 'Author:'), 1, wx.ALL, 3)
        sizerC.Add((22,22), 0, wx.ALL, 3)
        sizerC.Add(self.authorIsCorporateCb, 1, wx.ALL, 3)

        sizerA.Add(self.authorCtrl, 1, wx.ALL, 3)
        sizerA.Add(self.authorSwapButton, 0, wx.ALL, 3)
        sizerA.Add(self.authorAltCtrl, 1, wx.ALL, 3)

        sizerB.Add(self.titleCtrl, 1, wx.ALL, 3)
        sizerB.Add(self.titleSwapButton, 0, wx.ALL, 3)
        sizerB.Add(self.titleAltCtrl, 1, wx.ALL, 3)

        sizerD.Add(wx.StaticText(self.panelx, -1, 'Date of publication:'), 1, wx.ALL, 3)
        sizerD.Add((22,22), 0, wx.ALL, 3)
        sizerD.Add(self.datePicker, 1, wx.ALL, 3)

        sizerF.Add((20, 20), 3, wx.EXPAND, 0)
        sizerF.Add(self.btCancel, 0, wx.ALL, 3)
        sizerF.Add(self.btOk, 0, wx.ALL, 3)

        sizer1.Add(wx.StaticText(self.panelx, -1, 'BibTeX key:'), 0, wx.ALL, 3)
        sizer1.Add(sizerE, 0, wx.EXPAND)
        sizer1.Add(sizerC, 0, wx.EXPAND)
        sizer1.Add(sizerA, 0, wx.EXPAND)
        sizer1.Add(wx.StaticText(self.panelx, -1, 'Title:'), 0, wx.ALL, 3)
        sizer1.Add(sizerB, 0, wx.EXPAND)
        sizer1.Add(sizerD, 0, wx.EXPAND)
        sizer2.Add(self.choiceBook, 1, wx.ALL|wx.EXPAND, 3)

        sizer3.Add(sizer1, 0, wx.EXPAND)
        sizer3.Add(sizer2, 1, wx.EXPAND)
        sizer3.Add(sizerF, 0, wx.EXPAND)
        self.panelx.SetSizer(sizer3)
        self.panelx.Layout()
        
        sizer4.Add(self.panelx, 1, wx.EXPAND)
        
        self.SetSizer(sizer4)
        self.Layout()
        self.Refresh()

    def __fill_fields(self, bibdata):
        self.silentdata = {}
        for k in self.silentfields:
            if bibdata.has_key(k):
                self.silentdata[k] = bibdata[k]
        if bibdata.has_key('bibtex_key'):
            self.keyAutoCb.SetValue(False)
            self.keyCtrl.SetValue(bibdata['bibtex_key'])
        else:
            self.keyAutoCb.SetValue(True)
            self.keyCtrl.SetValue(autogen_bibtex_key(bibdata))
            self.keyCtrl.Enable(False)
        if not bibdata.has_key('corporate_author'):
            self.authorIsCorporateCb.Set3StateValue(wx.CHK_UNDETERMINED)
        elif bibdata['corporate_author'] == True:
            self.authorIsCorporateCb.Set3StateValue(wx.CHK_CHECKED)
        else:
            self.authorIsCorporateCb.Set3StateValue(wx.CHK_UNCHECKED)
        self.authorCtrl.SetValue(bibdata['author'])
        self.authorAltCtrl.SetValue(bibdata['internal_author'])
        self.titleCtrl.SetValue(bibdata['title'])
        self.titleAltCtrl.SetValue(bibdata['internal_title'])
        t = wx.DateTimeFromTimeT(time.mktime(bibdata['creation_date']))
        self.datePicker.SetValue(t)
        print bibdata['bibtex_type']
        self.choiceBook.ChangeSelection(self.panelref.index(bibdata['bibtex_type'].lower()))
        self.choiceBook.GetCurrentPage().setData(bibdata)
        self.authorCtrl.SetFocus()        

    def onKeygenToggle(self, evt):
        if self.keyAutoCb.IsChecked():
            self.keyCtrl.Enable(False)
        else:
            self.keyCtrl.Enable(True)

    def getData(self):
        return self._bibdata
    
    def onOk(self, evt=1):
        tmpbibdata = {}
        for k, v in self.silentdata.items():
            tmpbibdata[k] = v
        for ctrl in (self.keyCtrl, self.authorCtrl, self.titleCtrl):
            if not ctrl.GetValidator().Validate():
                wx.MessageBox("One or more of these fields has problematic syntax for BibTeX - please remedy")
                return
        tmpbibdata['author'] = self.authorCtrl.GetValue()
        tmpbibdata['title'] = self.titleCtrl.GetValue()
        newdate = wxdate2pydate(self.datePicker.GetValue())
        tmpbibdata['year'] = unicode(newdate.year)
        tmpbibdata['creation_date'] = newdate.timetuple()
        tmpbibdata['month'] = time.strftime('%B', tmpbibdata['creation_date'])
        if not self.keyAutoCb.IsChecked():
            tmpbibdata['bibtex_key'] = self.keyCtrl.GetValue()
        corpcb = self.authorIsCorporateCb.Get3StateValue()
        if corpcb == wx.CHK_UNCHECKED:
            tmpbibdata['corporate_author'] = False
        elif corpcb == wx.CHK_CHECKED:
            tmpbibdata['corporate_author'] = True
        cbp = self.choiceBook.GetCurrentPage()
        try:
            et, moredata = cbp.getData()
        except Exception, exc:
            wx.MessageBox(unicode(exc))
            return
        tmpbibdata['bibtex_type'] = et
        tmpbibdata.update(moredata)
        import pprint
        pprint.pprint(tmpbibdata)
        self._bibdata = tmpbibdata
        self.EndModal(wx.ID_OK)

    def onCancel(self, evt=1):
        self.EndModal(wx.ID_CANCEL)

    def onTitleSwap(self, evt):
        t = self.titleCtrl.GetValue()
        self.titleCtrl.SetValue(self.titleAltCtrl.GetValue())
        self.titleAltCtrl.SetValue(t)

    def onAuthorSwap(self, evt):
        t = self.authorCtrl.GetValue()
        self.authorCtrl.SetValue(self.authorAltCtrl.GetValue())
        self.authorAltCtrl.SetValue(t)

    def onFieldValidate(self, evt):
        obj = evt.GetEventObject()
        obj.GetValidator().Validate()



if __name__ == "__main__":
    spoofdata = {
        'title': 'Spoof title',
        'bibtex_type': 'misc',
        'author': '{Goldman Saks}',
        'year': '1833',
        'month': 'January',
        'howpublished': 'Mungdinügn',
        'url': 'http://www.themong.spo.nn/a%20b.html',
        'annote': 'notey',
        'ancillary_downloadtime': time.localtime(),
        'ancillary_creationtime': time.localtime(),
        'ancillary_outfilename': 'C:noodles',
        'ancillary_locofdoc': 'http://www.hell.no',
        'exclude': True,
        'internal_author': 'Jon Hoo',
        'internal_title': 'Noh Wai',
        'creation_date': time.localtime()
        }
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    dialog_1 = pieMultiBibEditDialog(spoofdata, None, -1, "")
    app.SetTopWindow(dialog_1)
    dialog_1.Show()
    app.MainLoop()
