# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .netcontrollers import *


logger = logging.getLogger()
NETControllers = {}


try:
    NETControllers.setdefault('NATIR')
    NETControllers['NATIR'] = NATIR
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    NETControllers.setdefault('NCM11')
    NETControllers['NCM11'] = NCM11
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    NETControllers.setdefault('NCM15')
    NETControllers['NCM15'] = NCM15
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    NETControllers.setdefault('NRFXCOM')
    NETControllers['NRFXCOM'] = NRFXCOM
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    NETControllers.setdefault('NRFXTRX')
    NETControllers['NRFXTRX'] = NRFXTRX
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    NETControllers.setdefault('NTSDUO')
    NETControllers['NTSDUO'] = NTSDUO
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))
