# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading
if sys.hexversion < 0x030000F0:
    import ConfigParser as cp
else:
    import configparser as cp
from .corelibs import (newalias,alias2hu,huoralias,hu2alias,hudevice,lsdev)
from .parsecmds import(cmdinputf,cmdinputh)
from .servers import (INPUTq,SetupDaemons)

logger = logging.getLogger()


AdminCmds ={
    }
RPCFunctions = []

config = cp.RawConfigParser()
config.read(['initvars.cfg'])
fcthuName = config.get('RPCcmdName','fcthuName')
if fcthuName == '': fcthuName = 'fcthu'
phufctName = config.get('RPCcmdName','phufctName')
if phufctName == '': phufctName = 'phufct'



def alias_rpc(param):
    if not param:
        return lsdev('ALIAS')
    a = param.split()
    if len(a) == 1:
        hu = huoralias(param)
        if hu:
            if hu == param:
                return hu2alias(hu) + ' : ' + param
            else:
                return param + ' : ' + alias2hu(param)
        else:
            return 'NoAlias' + ' : ' + param
    else:
        return newalias(['newalias'] + a)
RPCFunctions.append((alias_rpc, 'alias'))


def fcthu_rpc(params):
    """
    Input : 2 parameters
    Function(on/off) HouseUnit
    HouseUnit : equivalent to device and protocol if exits
    if not, protocol default to PL
    """
    a = params.split()
    if len(a) == 2 and (a[0].lower() in ('on','off')):
        res = cmdinputf(params)
    else:
        res = 'Input error'
    return res
RPCFunctions.append((fcthu_rpc, fcthuName))


def phufct_rpc(params):
    """
    Input : 3 parameters
    Protocol HouseUnit(addressId) Function(on/off)
    """
    return cmdinputh(params)
RPCFunctions.append((phufct_rpc, phufctName))


def infos_rpc(params):
    print (repr(SetupDaemons))
    print (repr(threading.enumerate()))
    return True
RPCFunctions.append((infos_rpc, 'infos'))


def lsdev_rpc(param):
    return lsdev(param)
RPCFunctions.append((lsdev_rpc, 'lsdev'))


def stops_rpc(params):
    if params in SetupDaemons:
        SetupDaemons[params].stops()
        res = ('STOPPING %s...' % params)
        del SetupDaemons[params]
    else:
        res = 'Input error'
    return res
RPCFunctions.append((stops_rpc, 'stops'))
AdminCmds.setdefault('STOPsrv')
AdminCmds['STOPsrv'] = stops_rpc

