"""
IMPORTANT:

The RFXtrx433 documentation and code files contain the Copyright message and Software License Agreement below.
Your software for the RFXtrx interface should contain the Software License Agreement.

 

Copyright 2011-2013, RFXCOM

 

ALL RIGHTS RESERVED. This document contains material protected under Netherlands Copyright Laws and Treaties and shall be subject to the exclusive jurisdiction of the Netherlands Courts. The information from this document may freely be used to create programs to exclusively interface with RFXCOM products only. Any other use or unauthorized reprint of this material is prohibited. No part of this document may be reproduced or transmitted in any form or by any means, electronic or mechanical, including photocopying, recording, or by any information storage and retrieval system without express written permission from RFXCOM.

 

//----------------------------------------------------------------------------

//                     Software License Agreement                     

//                                                                    

// Copyright 2011-2013, RFXCOM

//

// ALL RIGHTS RESERVED. This code is owned by RFXCOM, and is protected under

// Netherlands Copyright Laws and Treaties and shall be subject to the

// exclusive jurisdiction of the Netherlands Courts. The information from this

// file may freely be used to create programs to exclusively interface with

// RFXCOM products only. Any other use or unauthorized reprint of this material

// is prohibited. No part of this file may be reproduced or transmitted in

// any form or by any means, electronic or mechanical, including photocopying,

// recording, or by any information storage and retrieval system without

// express written permission from RFXCOM.

//

// The above copyright notice shall be included in all copies or substantial

// portions of this Software.

//-----------------------------------------------------------------------------

"""

import logging
from .parserlibs import (my_fctname,coroutine,db2dict,header,updtnewsensor)
from .rfxtrxlibs import *

logger = logging.getLogger()


@my_fctname
@coroutine
def sensordecoder(targets,rejected=None,newids=None):
    """
    Decoders for Oregon sensor events from RFXTRX
    """
    ids = db2dict('SENSORIDS')
    rows = RFXTRXDECODERS
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, type, subtype, data, p, protocol, revt, decrow = msgs
        if protocol != 'oregon' : continue
       	logger.debug("Protocol %s type %s subtype %s",protocol, type, subtype)
        if decrow in rows:
            row = rows[decrow]
        else:
            if rejected: rejected.send(['DECODER_NOT_IMPLEMENTED',protocol] + msgs)
            continue
        model = type2model(type,subtype)
       	ld = row[0].split()
       	try:
       	    res = eval(row[1])
       	except Exception as e:
       	    logger.debug("Exception / Error %s",repr(e))
       	    if rejected: rejected.send(['ERR_DECODE',repr(row[1])] + msgs)
       	    continue
       	#Sensor Unit / Id
        if 'AddrId' in ld:
            addr = res[ld.index('AddrId')]
            logger.debug("Address of Sensor  %s",addr)
            V = (protocol,model,addr)
       	    if V in ids:
                unit = ids[V]
            else:
                logger.debug("New sensor detected %s", repr(V))
                if newids: ids = updtnewsensor([protocol, model, addr,row[0],type,subtype])
       	        continue
       	hd = header(namedev)
       	for d in ld:
       	    event = hd + [d, unit, res[ld.index(d)]]
            logger.debug("Function sensordecoder for %s",repr(event))
            for target in targets:
                target.send(event)

