# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .parserlibs import (my_fctname,coroutine,db2dict,header,updtnewdevice)
from .x10libs import *

logger = logging.getLogger()


@my_fctname
@coroutine
def devdecoder(targets,rejected=None,newids=None,rawevt=None):
    """
    Decoders for X10 RF and ARC Self learning / RFXCom and TSDuo controllers
    """
    ids = db2dict('DEVICEIDS')
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, protocol, data, p, model, hdlen,revt = msgs
        if hdlen == '0x5a': continue
        if protocol not in ('x10','arctech') : continue
        if protocol == 'x10':
            row = '[hex2x10rf(p)]'
        elif protocol == 'arctech':
            row = '[archuf(p)]'
       	try:
       	    res = eval(row)
       	except Exception as e:
       	    logger.error("Exception / Error %s",repr(e))
       	    if rejected: rejected.send(['ERR_DECODE',repr(row)] + msgs)
       	    continue
       	logger.debug("Result %s",repr(res))
        huf = res[0]
        if huf:
            hu,f = huf
        else:
       	    logger.debug("No house unit decoded with : %s",repr(msgs))
       	    if rejected: rejected.send(['FAIL_DECODE',repr(row)] + msgs)
       	    continue
        decevt = [protocol,hu,f]
        event = header(namedev) + decevt
        for target in targets:
            logger.debug("Function rxdevdecoder for %s",repr(event))
            target.send(event)
        #Device Unit / addr
        if (protocol, hu) not in ids:
            logger.debug("New device detected with unit %s", hu)
            if newids: ids = updtnewdevice([protocol,hu])
        if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])
