# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------
"""
Software HEYU Team
------------------
- Website: http://www.heyu.org
- HEYU is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from HEYU
  * piHAparsers/orelibs
  * piHAparsers/x10libs
"""



def archuf(p):
   """
   Event p : [0xc7 0xe0 0x5d 0xda 0x00]
   Self learning device
   Decode House Unit(addr:u) and Function(cmd)
   """
   addr = ((p[0] << 18) + (p[1] << 10) + (p[2] << 2) + (p[3] >> 6))
   addr = '0x%07x' % addr
   cmd = (p[3] >> 4) & 0x3
   u = (cmd & 0x2) and 'group' or ('%02d' % ((p[3] & 0xf) + 1))
   cmd = (cmd & 0x1) and 'on' or 'off'
   if u == 'group':
       cmd = 'group_' + cmd
       unit = addr + ':01'
   else:
       unit = addr + ':' + u
   if len(p) in (6,7):
       level = p[4] >> 4
       cmd='preset:' + str(level)
   return unit,cmd
