# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


import logging,sqlite3,sys
if sys.hexversion < 0x030000F0:
    import ConfigParser as cp
else:
    import configparser as cp

logger = logging.getLogger()


def initdbconn():
    DefaultDB3 = 'dbase.db3'
    config = cp.RawConfigParser()
    config.read(['initvars.cfg'])
    DefaultDB3 = config.get('SqliteDB','ConfigDB')
    conn = sqlite3.connect(DefaultDB3, check_same_thread=False)
    conn.text_factory = str
    return conn
DefaultCONN = initdbconn()


ListReplicateDb = []
def majdb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    conn.commit()
    for db in ListReplicateDb:
        try:
             conn1 = sqlite3.connect(db)
             cur = conn1.cursor()
             cur.execute(req,data)
             conn1.commit()
             conn1.close()
        except:
             pass


def ralldb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    rows = cur.fetchall()
    return rows


def reqdb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    row = cur.fetchone()
    return row

