# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Net Controllers derived from Generic Controller
# Receiving data / Network 
# Python 2.7.x and 3.x
# ----------------------------------------------------------------------------

import logging
from .netctrlibs import NETCTRL

logger = logging.getLogger()

class NATIR(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,rxaddr=addr)
        self.idcontroller = 'NATIR'
        self.name = 'NATIR'
        self.TXcap = False
        self.RXcap = True

    def netsend(self,data):
        return None


class NCM11(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,txaddr=addr)
        self.name = 'NCM11'
        self.TXcap = True
        self.RXcap = True

    def netsend(self,data):
        NETCTRL.netsend(self,data)

    def rxevent(self):
        return None


class NCM15(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,txaddr=addr)
        self.idcontroller = 'NCM15'
        self.name = 'NCM15'
        self.TXcap = True
        self.RXcap = True

    def netsend(self,data):
        NETCTRL.netsend(self,data)

    def rxevent(self):
        return None


class NRFXCOM(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,rxaddr=addr)
        self.idcontroller = 'NRFXCOM'
        self.name = 'NRFXCOM'
        self.TXcap = False
        self.RXcap = True

    def netsend(self,data):
        return None


class NRFXTRX(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,rxaddr=addr)
        self.idcontroller = 'NRFXTRX'
        self.name = 'NRFXTRX'
        self.RXcap = True
        self.TXcap = True

    def netsend(self,data):
        return None


class NTSDUO(NETCTRL):

    def __init__(self,addr=None):
        NETCTRL.__init__(self,rxaddr=addr)
        self.idcontroller = 'NTSDUO'
        self.name = 'NTSDUO'
        self.TXcap = True
        self.RXcap = True

    def netsend(self,data):
        return None
