# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .parserlibs import (my_fctname,coroutine)

logger = logging.getLogger()


def item2msgs(item):
    namedev = item[0]
    if 'CM15' not in namedev : return None
    sdata = item[1].split()
    hd = sdata[0]
    if hd not in ('0x5a','0x5d') : return None
    data = sdata[1:]
    if hd == '0x5d':
        hd = sdata[1]
        data = sdata[2:]
    logger.debug("Data to decode %s",repr(data))
    p = [ int(i,16) for i in data ]
    logger.debug("Packet to decode %s",repr(p))
    return [namedev,'x10', data, p, 'NC',hd,item[1]]


@my_fctname
@coroutine
def CM15parser(decoders):
    """
    Parse header for CM15
    item = [namedev,event]
    Send to next target = RF or PL decoder
    """
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        msgs = item2msgs(item)
        if not msgs : continue
        namedev, protocol, data, p, model, hd, revt =  msgs
        if hd == '0x5a':
            for target in decoders:
                if 'x10pl' in target.__name__:
                    logger.debug("Data PL sent to decoder %s",target.__name__)
                    target.send(msgs)
        else:
            for target in decoders:
                if 'x10pl' not in target.__name__:
                    logger.debug("Data RF sent to decoder %s",target.__name__)
                    target.send(msgs)


