# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .parserlibs import (my_fctname,coroutine,db2dict,header,updtnewdetector)
from .x10libs import *

logger = logging.getLogger()


@my_fctname
@coroutine
def detdecoder(targets,rejected=None,newids=None,rawevt=None):
    """
    Decoders for X10 RF Secured detectors and remotes / RFXCom and CM15 controllers
    """
    ids = db2dict('DETECTORIDS')
    lastevent = None
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, protocol, data, p, model, hdlen, revt = msgs
        if protocol != 'x10s' : continue
        logger.debug("Check for x10 RFSec with these values %s",repr(p))
       	if not chkssec1(p):
       	    if rejected: rejected.send(['FAIL_CHKS_sec1'] + data)
       	    continue
       	if not chkssec2(p):
       	    if rejected: rejected.send(['FAIL_CHKS_sec2'] + data)
       	    continue
       	hu = data[0] + data[4][2:] + data[5][2:]
        f = SECmap[data[2]]
        decevt = [protocol,hu,f]
        event = header(namedev) + decevt
        for target in targets:
            logger.debug("Function detdecoder for %s",repr(event))
            target.send(event)
        #Device Unit / addr
        if (protocol, hu) not in ids:
            logger.debug("New detector Id %s", hu)
            if newids: ids = updtnewdetector([protocol,hu])
        if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])
