# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------
"""
Software HEYU Team
------------------
- Website: http://www.heyu.org
- HEYU is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from HEYU
  * piHAparsers/orelibs
  * piHAparsers/x10libs

Software MOCHAD Author
----------------------
- Website: http://sourceforge.net/apps/mediawiki/mochad/index.php?title=Main_Page
- MOCHAD is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from MOCHAD
  * piHAparsers/x10libs
"""
# ----------------------------------------------------------------------------
# Use to convert hex string to x10 data
# For CM11a powerline events read RX and transmit TX
# For CM15a powerline events RX and TX
# ----------------------------------------------------------------------------

from .x10codes import *

def hstr2int(byte):
   """
   Convert a hex string 0xii into a sequence of 2 integers use for index
   """
   hexa = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f']
   return [ hexa.index(byte[2].lower()), hexa.index(byte[3].lower()) ]


def hex2hu(byte):
   """
   Convert a hex string to X10 house code and unit code
   """
   return iHC[hstr2int(byte)[0]].upper() + iUC[hstr2int(byte)[1]]


def hex2hf(byte):
   """
   Convert a hex string to seq X10 house code and function
   """
   return [iHC[hstr2int(byte)[0]].upper(), iFC[str(hstr2int(byte)[1])].upper()]


def hex2dbl(byte):
   """
   Convert a X10 byte hex string to dim bright level in int
   """
   return (int(byte,16) ^ 6) >> 3


def hu2hex(hu):
   """
   Convert a X10 house+unit string to int
   """
   return (iHC.index(hu[0].lower()) << 4) | iUC.index(hu[1:].lower())


def hf2hex(h,f):
   """
   Convert a X10 sequence of 2 strings [house = h, fonction = f] to int
   """
   return (iHC.index(h.lower()) << 4) | xFC[f.lower()]


def dbl2hex(dbl):
   """
   Convert a X10 dbl level in int to int / header byte
   """
   return (int(dbl) << 3) | 0x6


def x10pl2hex(args):
   """
   Convert an X10 command in human readable form:
	hu : house hu[0] + unit hu[1:] in string format
	f : 'ON' or 'OFF' / l : None
        f: 'DIM' or 'BRIGHT' / l : amount from '1' to '22'
   into hex seq for CM11a and CM15a X10 powerline
   """
   hu,f,l = args
   if l:
       a = [dbl2hex(l),hu2hex(hu),hf2hex(hu[0],f)]
       return ' '.join(['0x%02x' % i  for i in a])
   else:
       a = [hu2hex(hu),hf2hex(hu[0],f)]
       return ' '.join(['0x%02x' % i  for i in a] + ['0x00'])


def x10decode1(evt):
   try:
       hf = hex2hf(evt[2])
       b = hf[1]
       f = xFC[b.lower()]
       if (f in (4,5)) and (int(evt[0],16) == 3):			#functions DIM/BRIGHT (evt[3] code dbl dim level)
           b = hf[1] +'(' + str(hex2dbl(evt[3])) + ')'
   except:
       return None
   return [hf,b,f]


def x10decode2(dev,evt):
   try:
       if dev == 'CM11':
           hu = hex2hu(evt[2])
           hf = hex2hf(evt[3])
       if dev == 'CM15':
           hu = None
           hf = hex2hf(evt[3])
           b = hf[1]
           f = xFC[b.lower()]
           if (f in (4,5)):					#functions DIM/BRIGHT (evt[2] code dbl dim level)
               hf[1] = b +'(' + str(hex2dbl(evt[2])) + ')'
   except:
       return None
   return [hu,hf]
