# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,time
if sys.hexversion < 0x030000F0:
    import ConfigParser as cp
else:
    import configparser as cp

from piHAparsers import (Decoders,Parsers)
from .corelibs import (adstr2addr,debug,log2console,log2file,printer,sysevents)
from .controller import CONTROLLER
from .netcontroller import NETCONTROLLER
from .parsecmds import ParseCMDS
from .rpccmds import (AdminCmds,RPCFunctions)
from .servers import (Servers,SetupDaemons,evtnetqueue)

logger = logging.getLogger()


PostTargets = {
    'DEBUG':debug(),
    'LOG2FILE':log2file('decoded.log'),
    'PRINTER':printer(),
    }
posttargets = [printer(),]

config = cp.RawConfigParser()
config.read(['initvars.cfg'])
SYSLogfile = config.get('ServersArgs','SYSLogfile')
RPCSAddport = config.get('ServersArgs','RPCSAddport')
TCPRXAddport = config.get('ServersArgs','TCPRXAddport')
TCPSAddport = config.get('ServersArgs','TCPSAddport')



def startsrvs(trx=True,ttx=True):
    syslogf = Servers['SYSF'](SYSLogfile)
    syslogf.features.append(sysevents(AdminCmds))
    syslogf.tsetup()
    syslogf.starts()
    SetupDaemons.setdefault('SYSF')
    SetupDaemons['SYSF'] = syslogf

    inparser = Servers['INParser']()
    inparser.Functions.update(ParseCMDS)
    inparser.tsetup()
    inparser.starts()
    SetupDaemons.setdefault('INParser')
    SetupDaemons['INParser'] = inparser

    if RPCSAddport !=  '':
        rpcs = Servers['RPCS'](adstr2addr(RPCSAddport))
        rpcs.Functions += RPCFunctions
        rpcs.tsetup()
        rpcs.starts()
        SetupDaemons.setdefault('RPCS')
        SetupDaemons['RPCS'] = rpcs

    if trx and TCPRXAddport !=  '':
        tcprx = Servers['TCPRX'](adstr2addr(TCPRXAddport))
        tcprx.tsetup()
        tcprx.starts()
        SetupDaemons.setdefault('TCPRX')
        SetupDaemons['TCPRX'] = tcprx

    if ttx and TCPSAddport !=  '':
        tcps = Servers['TCPS'](adstr2addr(TCPSAddport))
        tcps.tsetup()
        tcps.starts()
        SetupDaemons.setdefault('TCPS')
        SetupDaemons['TCPS'] = tcps


def useparser(ctrl,dev):
    for decoder in Decoders[ctrl]:
        dev.decoders.append(decoder(posttargets))
    dev.featurenames.append(ctrl + '-PARSER')
    dev.features.append(Parsers[ctrl](dev.decoders))


def usecontroller(ctrl,port):
    try:
        dev = CONTROLLER(ctrl,port)
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        return None
    dev.name = 'CTRL'
    dev.tsetup()
    if not dev.setup: return None
    dev.allrxtx()
    SetupDaemons.setdefault(ctrl)
    SetupDaemons[ctrl] = dev
    if 'TCPRX' in SetupDaemons:
        dev.featurenames.append('EVTNETQUEUE')
        dev.features.append(evtnetqueue())
    return dev

def usenetcontroller(nctrl,hostport):
    try:
        dev = NETCONTROLLER(nctrl,hostport)
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        return None
    dev.name = 'NETCTRL'
    dev.tsetup()
    if not dev.setup: return None
    dev.allrxtx()
    SetupDaemons.setdefault(nctrl)
    SetupDaemons[nctrl] = dev
    return dev
