# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .parserlibs import (my_fctname,coroutine,db2dict,header)
from .x10libs import *

logger = logging.getLogger()


@my_fctname
@coroutine
def rxremote(targets,rejected=None,newids=None,rawevt=None):
    """
    Decoders for X10 Remote / RFXCom and ATI Remote Receiver
    """
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, protocol, data, p, model, hdlen,revt = msgs
        if protocol != 'ati' : continue
        hu = hcrfremote(p)
        if hu:
            row = '[pcrmap(p)]'
        else:
            row = '[atirmap(p)]'
            hu = 'NC'
       	try:
       	    res = eval(row)
       	except Exception as e:
       	    logger.error("Exception / Error %s",repr(e))
       	    if rejected: rejected.send(['ERR_DECODE',repr(row)] + msgs)
       	    continue
       	logger.debug("Result %s",repr(res))
        f = res[0]
        if not f:
       	    logger.debug("No key map with : %s",repr(msgs))
       	    if rejected: rejected.send(['FAIL_MAP',repr(row)] + msgs)
       	    continue
        decevt = [protocol,hu,f]
        event = header(namedev) + decevt
        for target in targets:
            logger.debug("Function rxremote for %s",repr(event))
            target.send(event)
        if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])

