# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------
"""
Software HEYU Team
------------------
- Website: http://www.heyu.org
- HEYU is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from HEYU
  * piHAparsers/orelibs
  * piHAparsers/x10libs

Software MOCHAD Author
----------------------
- Website: http://sourceforge.net/apps/mediawiki/mochad/index.php?title=Main_Page
- MOCHAD is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from MOCHAD
  * piHAparsers/x10libs
"""

# ----------------------------------------------------------------------------
# Codes use to encode and decode X10 powerline
# For CM11a powerline events read RX and transmit TX
# For CM15a powerline events RX and TX
# ----------------------------------------------------------------------------

#House code
iHC = ['m','e','c','k','o','g','a','i','n','f','d','l','p','h','b','j']

#Unit Code
iUC = ['13','5','3','11','15','7','1','9','14','6','4','12','16','8','2','10']

#Function Code
iFC = {
	'0' : 'all_units_off',
	'1' : 'all_lights_on',
	'2' : 'on',
	'3' : 'off',
	'4' : 'dim',
	'5' : 'bright',
	'6' : 'all_lights_off'
	}
xFC = {
	'all_units_off': 0,
	'all_lights_on': 1,
	'on' : 2,
	'off' : 3,
	'dim' : 4,
	'bright' : 5,
	'all_lights_off': 6
	}


# ----------------------------------------------------------------------------
# Codes use to encode and decode X10 RF
# For CM15a X10 RF events RX and TX
# ----------------------------------------------------------------------------

#House Code for CM15 X10 RF
iHCrf = ['m','n','o','p','c','d','a','b','e','f','g','h','k','l','i','j']




# ----------------------------------------------------------------------------
# Codes use to decode X10 RF remotes
# ATI Remote Wonder
# X10 RF PC remotes
# X10 RF Secured remotes
# ----------------------------------------------------------------------------

ATIrmap = {
    '0xd20d':'KEY_1',
    '0xd30e':'KEY_2',
    '0xd40f':'KEY_3',
    '0xd510':'KEY_4',
    '0xd611':'KEY_5',
    '0xd712':'KEY_6',
    '0xd813':'KEY_7',
    '0xd914':'KEY_8',
    '0xda15':'KEY_9',
    '0xdc17':'KEY_0',
    '0xc500':'KEY_A',
    '0xc601':'KEY_B',
    '0xde19':'KEY_C',
    '0xe01b':'KEY_D',
    '0xe621':'KEY_E',
    '0xe823':'KEY_F',
    '0xdd18':'KEY_KPENTER',
    '0xdb16':'KEY_MENU',
    '0xc702':'KEY_POWER',
    '0xc803':'KEY_TV',
    '0xc904':'KEY_DVD',
    '0xca05':'KEY_WWW',
    '0xcb06':'KEY_BOOKMARKS',
    '0xcc07':'KEY_EDIT',
    '0xe11c':'KEY_COFFEE',
    '0xe520':'KEY_FRONT',
    '0xe21d':'KEY_LEFT',
    '0xe41f':'KEY_RIGHT',
    '0xe722':'KEY_DOWN',
    '0xdf1a':'KEY_UP',
    '0xe31e':'KEY_OK',
    '0xce09':'KEY_VOLUMEDOWN',
    '0xcd08':'KEY_VOLUMEUP',
    '0xcf0a':'KEY_MUTE',
    '0xd00b':'KEY_CHANNELUP',
    '0xd10c':'KEY_CHANNELDOWN',
    '0xec27':'KEY_RECORD',
    '0xea25':'KEY_PLAY',
    '0xe924':'KEY_REWIND',
    '0xeb26':'KEY_FORWARD',
    '0xed28':'KEY_STOP',
    '0xee29':'KEY_PAUSE',
    '0xf02b':'KEY_PREVIOUS',
    '0xef2a':'KEY_NEXT',
    '0xf22d':'KEY_INFO',
    '0xf32e':'KEY_HOME',
    '0xf42f':'KEY_END',
    '0xf530':'KEY_SELECT',
    }

PCrmap = {
    '0x00':'UNKNOWN_00(0)',
    '0x01':'DVD_ANGLE(1)',
    '0x02':'POWER_STANDBY(2)',
    '0x03':'LIVE_TV(3)',
    '0x04':'DVD_MENU(4)',
    '0x05':'PHOTOS(5)',
    '0x06':'MUSIC(6)',
    '0x07':'UNKNOWN_07(7)',
    '0x08':'VOLUME_MINUS(8)',
    '0x09':'VOLUME_PLUS(9)',
    '0x0a':'MUTE(10)',
    '0x0b':'CHANNEL_PLUS(11)',
    '0x0c':'CHANNEL_MINUS(12)',
    '0x0d':'BUTTON_1(13)',
    '0x0e':'BUTTON_2(14)',
    '0x0f':'BUTTON_3(15)',
    '0x10':'BUTTON_4(16)',
    '0x11':'BUTTON_5(17)',
    '0x12':'BUTTON_6(18)',
    '0x13':'BUTTON_7(19)',
    '0x14':'BUTTON_8(20)',
    '0x15':'BUTTON_9(21)',
    '0x16':'TELETEXT(22)',
    '0x17':'BUTTON_0(23)',
    '0x18':'RECORDED_TV(24)',
    '0x19':'UNKNOWN_19(25)',
    '0x1a':'UP(26)',
    '0x1b':'MEDIA_MENU(27)',
    '0x1c':'UNKNOWN_1C(28)',
    '0x1d':'LEFT(29)',
    '0x1e':'OK(30)',
    '0x1f':'RIGHT(31)',
    '0x20':'QUIT(32)',
    '0x21':'REPLAY(33)',
    '0x22':'DOWN(34)',
    '0x23':'SKIP(35)',
    '0x24':'REWIND(36)',
    '0x25':'PLAY(37)',
    '0x26':'FAST_FORWARD(38)',
    '0x27':'RECORD(39)',
    '0x28':'STOP(40)',
    '0x29':'PAUSE(41)',
    '0x2a':'UNKNOWN_2A(42)',
    '0x2b':'UNKNOWN_2B(43)',
    '0x2c':'UNKNOWN_2C(44)',
    '0x2d':'VIDEO(45)',
    '0x2e':'UNKNOWN_2E(46)',
    '0x2f':'INFO(47)',
    '0x30':'CLEAR(48)',
    '0x31':'GUIDE(49)',
    '0x32':'RED(50)',
    '0x33':'GREEN(51)',
    '0x34':'YELLOW(52)',
    '0x35':'BLUE(53)',
    '0x36':'ENTER(54)',
    '0x37':'BUTTON_ASTERISK(55)',
    '0x38':'BUTTON_POUND(56)',
    '0x39':'UNKNOWN_39(57)',
    '0x3a':'UNKNOWN_3A(58)',
    '0x3b':'UNKNOWN_3B(59)',
    '0x3c':'UNKNOWN_3C(60)',
    '0x3d':'UNKNOWN_3D(61)',
    '0x3e':'UNKNOWN_3E(62)',
    '0x3f':'UNKNOWN_3F(63)',
    '0x40':'UNKNOWN_40(64)',
    '0x41':'UNKNOWN_41(65)',
    '0x42':'UNKNOWN_42(66)',
    '0x43':'UNKNOWN_43(67)',
    '0x44':'UNKNOWN_44(68)',
    '0x45':'UNKNOWN_45(69)',
    '0x46':'UNKNOWN_46(70)',
    '0x47':'AUTOFOCUS(71)',
    '0x48':'UNKNOWN_48(72)',
    '0x49':'UNKNOWN_49(73)',
    '0x4a':'UNKNOWN_4A(74)',
    '0x4b':'UNKNOWN_4B(75)',
    '0x4c':'UNKNOWN_4C(76)',
    '0x4d':'UNKNOWN_4D(77)',
    '0x4e':'UNKNOWN_4E(78)',
    '0x4f':'UNKNOWN_4F(79)',
    '0x50':'ZOOM_IN(80)',
    '0x51':'ZOOM_OUT(81)',
    '0x52':'FOCUS_UP(82)',
    '0x53':'FOCUS_DOWN(83)',
    '0x54':'GOTO_PRESET_5(84)',
    '0x55':'SET_PRESET_5(85)',
    '0x56':'GOTO_PRESET_6(86)',
    '0x57':'SET_PRESET_6(87)',
    '0x58':'GOTO_PRESET_7(88)',
    '0x59':'SET_PRESET_7(89)',
    '0x5a':'GOTO_PRESET_8(90)',
    '0x5b':'SET_PRESET_8(91)',
    '0x5c':'GOTO_PRESET_9(92)',
    '0x5d':'SET_PRESET_9(93)',
    '0x5e':'IRIS_UP(94)',
    '0x5f':'IRIS_DOWN(95)',
    '0x60':'PAN_LEFT(96)',
    '0x61':'PAN_RIGHT(97)',
    '0x62':'TILT_UP(98)',
    '0x63':'TILT_DOWN(99)',
    '0x64':'GOTO_PRESET_1(100)',
    '0x65':'SET_PRESET_1(101)',
    '0x66':'GOTO_PRESET_2(102)',
    '0x67':'SET_PRESET_2(103)',
    '0x68':'GOTO_PRESET_3(104)',
    '0x69':'SET_PRESET_3(105)',
    '0x6a':'GOTO_PRESET_4(106)',
    '0x6b':'SET_PRESET_4(107)',
    '0x6c':'CENTER(108)',
    '0x6d':'CLEAR_ALL_POSITIONS(109)',
    '0x6e':'SWEEP(110)',
    }

SECmap = {
    '0x0c':'Motion_alert_MS10A',
    '0x8c':'Motion_normal_MS10A',
    '0x0d':'Motion_alert_low_MS10A',
    '0x8d':'Motion_normal_low_MS10A',
    '0x04':'Contact_alert_DS10A',
    '0x84':'Contact_normal_DS10A',
    '0x44':'Contact_alert_min_tamper_DS12A',
    '0xc4':'Contact_normal_min_tamper_DS12A',
    '0x00':'Contact_alert_max_DS10A',
    '0x80':'Contact_normal_max_DS10A',
    '0x40':'Contact_alert_max_tamper_DS12A',
    '0xc0':'Contact_normal_max_tamper_DS12A',
    '0x01':'Contact_alert_min_low_DS10A',
    '0x81':'Contact_normal_min_low_DS10A',
    '0x05':'Contact_alert_max_low_DS10A',
    '0x85':'Contact_normal_max_low_DS10A',
    '0x06':'arm_KR10A',
    '0x86':'Disarm_KR10A',
    '0x46':'Lights_On_KR10A',
    '0xc6':'Lights_Off_KR10A',
    '0x26':'Panic_KR10A',
    '0x03':'Panic_KR15A',
    '0x00':'UNKNOWN',
    '0x0e':'arm_Home_min_SH624',
    '0x06':'arm_away_min_SH624',
    '0x0a':'arm_Home_max_SH624',
    '0x02':'arm_away_max_SH624',
    '0x82':'Disarm_SH624',
    '0x22':'Panic_SH624',
    '0x42':'Lights_On_SH624',
    '0xc2':'Lights_Off_SH624',
    }
