# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime
from .sqlitedb import (majdb3,ralldb3,reqdb3)


def aliashu(a):
    req = 'SELECT unit FROM alias WHERE label = ?;'
    r = reqdb3(req,[a,])
    if r:
        return r[0]
    else:
        return None


def alias2hu(item):
    hu = aliashu(item)
    return hu


def hualias(a):
    req = "SELECT label FROM alias WHERE unit = ? AND typeunit = 'device';"
    r = reqdb3(req,[a.upper(),])
    if r:
        return r[0]
    req = 'SELECT label FROM alias WHERE unit = ?;'
    r = reqdb3(req,[a,])
    if r:
        return r[0]
    else:
        return None


def hudevice(a):
    req = 'SELECT deviceId,idencoder FROM deviceIds WHERE unit = ?;'
    r = reqdb3(req,[a,])
    if r:
        return r
    else:
        return None


def huoralias(item):
    alias = hualias(item)
    if alias:
        return item
    hu = aliashu(item)
    return hu

 

def huorhexid(item):
    if len(item) == 2:	#houseunit : => upper
        return item.upper()
    return item.lower()	#hexid : => lower


def hu2alias(item):
    hu = item.upper()
    alias = hualias(hu)
    if alias:
        return alias
    else:
        return 'NoAlias'


def lsdev(param):
    """
    list : alias detectors devices sensors
    """
    if param not in ('ALIAS','DETECTORS','DEVICES','SENSORS'): param = 'ALIAS'
    req = "SELECT '" + param + "',"
    if param == 'ALIAS':
        req +=  "unit,label,typeunit FROM alias;"
    elif param == 'DETECTORS':
        req +=  "idencoder,iddecoder,detectorId,d.unit,a.label "
        req +=  "FROM detectorIds as d, alias as a WHERE d.unit=a.unit;"
    elif param == 'DEVICES':
        req +=  "idencoder,deviceId,d.unit,a.label "
        req +=  "FROM deviceIds as d, alias as a WHERE d.unit=a.unit;"
    elif param == 'SENSORS':
        req +=  "iddecoder,modelId,sensorId,unit,label "
        req +=  "FROM sensorIds;"
    rows = ralldb3(req,())
    if not rows : return 'No ' + param + ' in DB'
    ls = []
    for row in rows:
        ls.append(' '.join(wspace2unders(row)))
    return '\n'.join(ls)


def newalias(data):
    """
    input : NEWALIAS HU ALIAS TYPE
    args = ['newalias', houseunit, alias, (type)]
    """
    if isinstance(data,list):
        items = data
    else:
        items = data.split()
    hu = huoralias(items[1])
    alias = items[2].replace(' ','_')
    if hu:		#replace for hu existant
        req = 'UPDATE alias SET label = ? WHERE unit = ?;'
        majdb3(req,[alias,hu])
        return 'Update Alias %s for Unit %s' % (alias,hu)
    else:
        tu = 'device'
        if len(items) == 4:
            if items[3].lower() in ('device','detector','sensor'):
                tu = items[3].lower()
        if tu == 'device':
            hu = items[1].upper()
        else:
            hu = items[1]
        req = "INSERT INTO alias(typeunit,label,unit) VALUES (?,?,?);"
        majdb3(req,[tu,alias,hu])
        return 'Add New Alias %s for Unit %s' % (alias,hu)



def wspace2unders(row):
    """
    replace white space by underscore in string in a row from DB
    """
    newrow = []
    for r in row:
        newrow.append(r.replace(' ','_'))
    return newrow
