# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,threading,time
from .serverlibs import (adstr2addr)

logger = logging.getLogger()


def chkcmdname(param,sdaemons):
    """
    param = cmd_namedev
    param = cmd_namedev
    namedev = identify daemon
    namedev = name + ':' + idctrl
    """
    p = param.split('_')
    cmd = p[0]
    if cmd == param:
        print ('Syntax error in parameter')
        return None
    namedev = p[1]
    if namedev in sdaemons:
        dev = sdaemons[namedev]
        if cmd not in dev.servercmds:
            print ('Command %s unknown for %s' % (cmd,repr(dev)))
            return None
        else:
            return dev.servercmds[cmd],namedev,dev
    else:
        print ('Daemon %s not yet setup' % namedev)
        return None


def chksetup(param,sdaemons):
    """
    param = name|daemonthread
    name  = identify daemonthread
         if None : name = id controller
    daemonthread = controller-port (-rxtx)
    if 'SCTRL': port = needed for serial
                       needed for USB if many controllers of same type
    if 'NCTRL' or 'SRV': port = host:port
    if 'NCTRL' : rxtx = RX (/ TX)
    """
    name = None
    idctrl = None
    port = None
    rxtx = None
    spp = None		#Second part of param
    #Parse syntax
    p = param.split('|')
    daemon = param
    if (len(p) == 1) and '-' not in param:
        name = p[0]
        idctrl = p[0]	#Use id of controller as name 
        spp = None
    if len(p) == 2:
        name = p[0]
        spp = p[1]
    if spp:
        d = spp.split('-')
        idctrl = d[0]
        if len(d) == 1:
             port = 'Defaults'
        elif len(d) == 2:
             port = d[1]
        elif len(d) == 3:
             port = d[1]
             rxtx = d[2]
    #Check if already setup
    namedev = name + ':' + idctrl
    if namedev in sdaemons:
        dev = sdaemons[namedev]
        if dev.setup:
             print ('%s already setup' % namedev)
             return None
        else:		# dev disconnected
             del sdaemons[namedev]
    return name, idctrl, port, rxtx


def lst2lines(thefile):
    import os
    lines = []
    i = 0
    try:
        f = open(thefile)
    except Exception as e:
        logger.critical("%s : %s", repr(e.__class__), str(e))
        return None
    for ln in f:
        if (ln == os.linesep) or (ln == ''):
            continue
        elif ln[0] == '#':
            continue
        lines.append(ln.rstrip(os.linesep))
        if i > 100:
            break
        else:
            i += 1
    return lines


def scriptexe(dev,lines):
    for ln in lines:
        if 'PAUSE' in ln:
            t = int(ln.split()[1])
            logger.debug("Macro execution PAUSE for %s seconds",t)
            time.sleep(t)
        else:
            dev.write(ln)
            dev.flush()
            time.sleep(1)


def serverthreads(srvtt):
    ths = threading.enumerate()
    for srv in ths:
        try:
            n = srv.__name__
        except:
            n = srv.name
        if srvtt in n:
            return srv
    return None

def infothreads():
    msg = []
    ths = threading.enumerate()
    for th in ths:
        try:
            thname = th.__name__ + ':' + repr(th)
        except:
            thname = th.name + ':' + repr(th)
        msg.append(thname)
    return msg
