# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
from .corelibs import (log2console)
from .corecmds import (SetupDaemons,startscript,startsysf,stopsrv)
from .menus import (coremenu2,coremenu3)

logger = logging.getLogger()

def main():
    if sys.hexversion < 0x020700F0:
        args = coremenu2()
    else:
        args = coremenu3()
    print ("Command line arguments : %s" % repr(args))

    if args['debug']:
        log2console()
        logger.setLevel(logging.DEBUG)

    if not startsysf(False): sys.exit()
    if not startscript(args['startscript']):
        stopsrv('STOPS_SYSLOGF')


if __name__ == '__main__':
    main()
