# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading

if sys.hexversion > 0x030000F0:
    from socketserver import StreamRequestHandler
    from socketserver import ThreadingTCPServer
else:
    from SocketServer import StreamRequestHandler
    from SocketServer import ThreadingTCPServer

from  .inputparser import (INPUTq)
from ..corelibs import (addr2host,coroutine)

logger = logging.getLogger()


class TCPCMDHandler(StreamRequestHandler):
    def handle(self):
        data = self.rfile.readline().strip()
        print ("{} wrote:".format(self.client_address[0]))
        print (data)
        INPUTq.put_nowait(data)
        self.wfile.write('Parsing input ...')

class TCPTXServer(ThreadingTCPServer):
    def __init__(self,addr=None):
        self.host,self.port = addr2host(defaddr=('localhost','9000'),addr=addr)
        self.handler = TCPCMDHandler
        self.allow_reuse_address
        self.type = 'SRV'
        self.name = 'TCPTXServer'
        self.cmdnetq = INPUTq
        self.servercmds = {'STARTS':self.starts,'STOPS':self.stops}

    def starts(self):
        tt = threading.Thread(target=self.serve)
        tt.name = 'TCPTXServer_' + self.name
        tt.daemon = True
        tt.start()
        print ('TCPTXServer started and active...')
 
    def tsetup(self):
        ThreadingTCPServer.__init__(self, (self.host, self.port), self.handler)
        self.setup = True

    def serve(self):
        print ('Listening at address %s on port number %s...\n' % (self.host, self.port))
        self.serve_forever()

    def stops(self):
        self.shutdown()
        print ('TCPTXServer shutting down...')

