# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------



# ----------------------------------------------------------------------------
# Use to receive RF events
# from ATI Remote Wonder receiver
# Receiving data / USB 
# Require pyUSB 1.0
# with Python 2.7.x and 3.x
# ----------------------------------------------------------------------------
# Software MOCHAD
# ---------------
# - Website: http://sourceforge.net/apps/mediawiki/mochad/index.php?title=Main_Page
# - MOCHAD is used as base for development of scripts
# ----------------------------------------------------------------------------


import logging
logger = logging.getLogger()

try:
    from .devcomm.devusb import DEVusb
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))
    from .devcomm.devusb0 import DEVusb


class ATIR(DEVusb):
    vendorId = 0x0BC7
    productId = 0x0004
    write_endpoint = 0x02
    read_endpoint = 0x81

    def __init__(self,port=None):
        DEVusb.__init__(self,port)
        self._id = '0bc7:0004'
        self.idcontroller = 'ATIR'
        self.TXcap = False
        self.RXcap = True
        self.setup = False

    def tsetup(self):
        self.open()
        try:
            logger.debug("Test reading %s....",self.idcontroller)
            data = self.read(100)
        except:
            self.opened = False
        if self.opened:
            logger.warning("%s Ready....",self.idcontroller)
            self.setup = True
            self.device = self.idcontroller + '-' + self.port
        return

    def request(self,rcmd):
        return None

    def plsend(self):
        return None

    def rfsend(self):
        return None

    def rxevent(self):
        """
        Reading data over RF
        Read [20 199 2 240]
        return '0x14 0xc7 0x02 0xf0'
        """
        evt = self.read(50)
        if not evt: return None
        event = ["0x%02x" % i for i in evt]
        return " ".join(event)
