# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time
if sys.hexversion < 0x030000F0:
    import ConfigParser as cp
else:
    import configparser as cp

from .coreactions import (addaction,rmaction)
from .coredecoders import (adddecoder,rmdecoder,addparser,rmparser)
from .corelibs import (adstr2addr,sysevents,lst2lines,startscriptexe)
from .coresetup import (
     mctrx,setupctrl,setupnetctrl,setupsrv,
     startsrv,stopsrv,
     Servers,SetupDaemons,SetupControllers,
     )
from .parsecmds import ParseCMDS
from .rpccmds import RPCFunctions

logger = logging.getLogger()

config = cp.RawConfigParser()
config.read(['pimucha.conf'])
STARTScript = config.get('FilesPath','STARTScript')
SYSLogfile = config.get('ServersArgs','SYSLogfile')
RPCSAddport = config.get('ServersArgs','RPCSAddport')
TCPRXAddport = config.get('ServersArgs','TCPRXAddport')
TCPSAddport = config.get('ServersArgs','TCPSAddport')


def runscript(script):
    thefile = STARTScript + script.lower() + '.scr'
    lines = lst2lines(thefile)
    if not lines:
        return False
    print('Executing %s...' % thefile)
    p = threading.Thread(target=startscriptexe, args=(SetupDaemons['SYSLOGF'],lines,))
    p.__name__ = 'ThreadSTARTscript_' + 'script'
    p.daemon = True
    p.start()
    return True


def startalls(trx=True,ttx=True):
    if RPCSAddport !=  '':
        rpcs = Servers['RPCS'](adstr2addr(RPCSAddport))
        rpcs.Functions += RPCFunctions
        rpcs.tsetup()
        rpcs.starts()
        SetupDaemons.setdefault('RPCS')
        SetupDaemons['RPCS'] = rpcs

    if trx and TCPRXAddport !=  '':
        tcprx = Servers['TCPRX'](adstr2addr(TCPRXAddport))
        tcprx.tsetup()
        tcprx.starts()
        SetupDaemons.setdefault('TCPRX')
        SetupDaemons['TCPRX'] = tcprx

    if ttx and TCPSAddport !=  '':
        tcps = Servers['TCPS'](adstr2addr(TCPSAddport))
        tcps.tsetup()
        tcps.starts()
        SetupDaemons.setdefault('TCPS')
        SetupDaemons['TCPS'] = tcps


def startsysf(daemon=True):
    syslogf = Servers['SYSLOGF'](SYSLogfile)
    syslogf.features.append(sysevents(AdminCmds))
    syslogf.tsetup()
    if not syslogf.setup : return False
    syslogf.starts(daemon)
    SetupDaemons.setdefault('SYSLOGF')
    SetupDaemons['SYSLOGF'] = syslogf

    inparser = Servers['INParser']()
    inparser.Functions.update(ParseCMDS)
    inparser.tsetup()
    inparser.starts()
    SetupDaemons.setdefault('INParser')
    SetupDaemons['INParser'] = inparser
    return True


def stopallctrls():
    SC = SetupControllers.keys()
    for ctrl in SC:
        stopsrv(SetupControllers[ctrl].namedev)


AdminCmds = {
    'ADDAction':addaction,
    'ADDDecoder':adddecoder,
    'ADDParser':addparser,
    'MCTRX':mctrx,
    'RMAction':rmaction,
    'RMDecoder':rmdecoder,
    'RMParser':rmparser,
    'SETUPctrl':setupctrl,
    'SETUPnetctrl':setupnetctrl,
    'SETUPsrv':setupsrv,
    'STARTsrv':startsrv,
    'STOPall':stopallctrls,
    'STOPsrv':stopsrv,
    'RUNscript':runscript,
    }
