# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time
if sys.hexversion > 0x030000F0:
    import queue as Queue
else:
    import Queue
QEmpty = Queue.Empty
from .corelibs import (broadcast,multievtqueue)
from .servers import SetupControllers

logger = logging.getLogger()


class MULTICTRX(object):
    def __init__(self):
        self.name = 'MULTICTRX'
        self.setup = False
        self.opened = False
        self.stop = False
        self.featurenames = []
        self.features = []
        self.decodernames = []
        self.decoders = []
        self.rxctrls = {}
        self.multievtq = Queue.Queue()
        self.servercmds = {
            'STARTM':self.startm,
            'STOPS':self.stops}

    def tsetup(self):
        try:
            for ctrl in self.rxctrls:
                self.rxctrls[ctrl].features.append(multievtqueue(self))
                logger.debug("Features rxctrls %s",repr(self.rxctrls[ctrl].features))
        except:
            pass
        self.setup = True
        self.opened = True

    def cleanm(self):
        if not self.setup: return
        for ctrl in self.rxctrls.keys():
            for f in self.rxctrls[ctrl].features:
                if f.__name__ == 'multievtqueue':
                    f.close()
        for d in self.decoders:
            d.close()
            self.decoders.remove(d)
        for d in self.decodernames:
            self.decodernames.remove(d)
        for f in self.features:
            f.close()
            self.features.remove(f)
        for f in self.featurenames:
            self.featurenames.remove(f)

    def dispatch(self,target):
        if not self.setup: return
        while not self.stop:
            event = None
            try:
                event = self.multievtq.get_nowait()
            except Queue.Empty:
                time.sleep(0.1)
            if event:
                target.send(event)
        self.cleanm()

    def allRXTX(self):
        self.dispatch(
            target=broadcast(self.features)
            )

    def startm(self):
        self.tt = threading.Thread(target=self.allRXTX)
        self.tt.name = 'MULTICTRXOf_' + self.name
        self.tt.start()
        self.ttname = self.tt.name
        print('%s starting...' % self.tt.name)

    def stops(self):
        self.stop = True
        print('%s stopping...' % self.ttname)

