# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,time
if sys.hexversion < 0x020700F0:
    from  optparse import OptionParser
else:
    import argparse

logger = logging.getLogger()


def coremenu2():
    helpusage = 'usage: %prog [options] startscript \n'
    helpusage += '\t\t startscript: file name (without extension and path) \n'
    helpusage += '\t\t default startscript: autostart'
    parser = OptionParser(usage=helpusage)
    parser.add_option('-d', '--debug', default=False, action='store_true')
    (options, args) = parser.parse_args()
    if len(args) != 1: args.append('autostart')
    rargs = vars(options)
    rargs.setdefault('startscript')
    rargs['startscript'] = args[0]
    return rargs


def coremenu3():
    helpscript = '\t\t startscript: file name (without extension and path) \n'
    helpscript += '\t\t default startscript: autostart'
    parser = argparse.ArgumentParser()
    parser.add_argument('startscript',nargs='?',help=helpscript,default='autostart')
    parser.add_argument('-d','--debug', default=False, action='store_true')
    return vars(parser.parse_args())


def mainmenu2():
    parser = OptionParser(usage='usage: %prog [options]')
    parser.add_option('-d', '--debug', default=False, action='store_true')
    parser.add_option('-c', '--ctrl',
                      type='choice',
                      action='store',
                      dest='ctrl',
                      choices=['ATIR', 'CM11', 'CM15', 'RFXCOM', 'RFXTRX', 'TSDUO'],
                      default='ATIR',
                      help='Controller to use',)
    parser.add_option('-p', '--port', action='store', default=None)
    parser.add_option('-n', '--net', action='store_true', default=False)
    parser.add_option('-a','--addressport', action='store', default='localhost:11000')
    parser.add_option('-e', '--eventparser', action='store_true', default=False)
    (options, args) = parser.parse_args()
    rargs = vars(options)
    return rargs


def mainmenu3():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d', '--debug', default=False, action='store_true')
    parser.add_argument('-c', '--ctrl',
                      action='store',
                      dest='ctrl',
                      choices=['ATIR', 'CM11', 'CM15', 'RFXCOM', 'RFXTRX', 'TSDUO'],
                      default='ATIR',
                      help='Controller to use',)
    parser.add_argument('-p', '--port', action='store', default=None)
    parser.add_argument('-n', '--net', action='store_true', default=False)
    parser.add_argument('-a','--addressport', action='store', default='localhost:11000')
    parser.add_argument('-e', '--eventparser', action='store_true', default=False)
    return vars(parser.parse_args())
