# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
logger = logging.getLogger()

from .cmdcheckers import *
from .cmdcontrollers import *
from .cmdencoders import *
from .pldevices import (x10pldecoder,x10plcdecoder)
from .rxdetectors import detdecoder
from .rxdevices import devdecoder
from .rxremotes import rxremote
from .rxsensors import oredecoder


Parsers = {}
Decoders = {}
DecoderNames = {
    'DEVDECODER':devdecoder,'OREDECODER':oredecoder,
    'DETDECODER':detdecoder,'RXREMOTE':rxremote,
    'X10PLDECODER':x10pldecoder,'X10PLCDECODER':x10plcdecoder,
    }

try:
    from .patir import ATIRparser
    Parsers.setdefault('ATIR')
    Parsers['ATIR'] = ATIRparser
    Decoders.setdefault('ATIR')
    Decoders['ATIR'] = [devdecoder,rxremote]
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .pcm11 import CM11parser
    Parsers.setdefault('CM11')
    Parsers['CM11'] = CM11parser
    Decoders.setdefault('CM11')
    Decoders['CM11'] = [x10pldecoder]
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .pcm15 import CM15parser
    Parsers.setdefault('CM15')
    Parsers['CM15'] = CM15parser
    Decoders.setdefault('CM15')
    Decoders['CM15'] = [devdecoder,detdecoder,rxremote,x10pldecoder,x10plcdecoder]
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .prfxcom import RFXCOMparser
    Parsers.setdefault('RFXCOM')
    Parsers['RFXCOM'] = RFXCOMparser
    Decoders.setdefault('RFXCOM')
    Decoders['RFXCOM'] = [devdecoder,detdecoder,oredecoder,rxremote]
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .ptsduo import TSDUOparser
    Parsers.setdefault('TSDUO')
    Parsers['TSDUO'] = TSDUOparser
    Decoders.setdefault('TSDUO')
    Decoders['TSDUO'] = [oredecoder,devdecoder]
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .prfxtrx import RFXTRXparser
    Parsers.setdefault('RFXTRX')
    Parsers['RFXTRX'] = RFXTRXparser
    from .trxdetectors import tdetdecoder
    from .trxdevices import tdevdecoder
    from .trxsensors import sensordecoder
    Decoders.setdefault('RFXTRX')
    Decoders['RFXTRX'] = [tdetdecoder,tdevdecoder,sensordecoder]
    DecoderNames.setdefault('TDETDECODER')
    DecoderNames['TDETDECODER'] = tdetdecoder
    DecoderNames.setdefault('TDEVDECODER')
    DecoderNames['TDEVDECODER'] = tdevdecoder
    DecoderNames.setdefault('SENSORDECODER')
    DecoderNames['SENSORDECODER'] = sensordecoder
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))
