# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------
"""
Python coroutines Tutorial
--------------------------
- David Beazley
- http://www.dabeaz.com
- Presented at PyCon'2009
"""

import logging,datetime,threading
from functools import wraps

logger = logging.getLogger()

def coroutine(func):
    def start(*args,**kwargs):
        cr = func(*args,**kwargs)
        next(cr)
        return cr
    return start

def my_fctname(f):
    @wraps(f)
    def wrapper(*args, **kwds):
        return f(*args, **kwds)
    return wrapper

@my_fctname
@coroutine
def debug():
    while True:
        msg = (yield)
        logger.debug(repr(msg))

def header(device):
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    return [device, d[0], d[1]]

def log2console():
    logger = logging.getLogger()
    hdlr = logging.StreamHandler() # Console
    formatter = logging.Formatter('%(module)s - %(asctime)s %(levelname)s %(message)s')
    hdlr.setFormatter(formatter)
    logger.addHandler(hdlr)

@coroutine
def log2file(logfile,sep=" "):
    while True:
        msg = (yield)
        line = sep.join([str(i) for i in msg])
        try:
            wf = open(logfile,'ab')
            wf.write(line + "\n")
            wf.close()
        except Exception as e:
            logger.error("%s : %s", repr(e.__class__), str(e))

@my_fctname
@coroutine
def printer():
    while True:
        msg = (yield)
        print (repr(msg))
