"""
IMPORTANT:

The RFXtrx433 documentation and code files contain the Copyright message and Software License Agreement below.
Your software for the RFXtrx interface should contain the Software License Agreement.

 

Copyright 2011-2013, RFXCOM

 

ALL RIGHTS RESERVED. This document contains material protected under Netherlands Copyright Laws and Treaties and shall be subject to the exclusive jurisdiction of the Netherlands Courts. The information from this document may freely be used to create programs to exclusively interface with RFXCOM products only. Any other use or unauthorized reprint of this material is prohibited. No part of this document may be reproduced or transmitted in any form or by any means, electronic or mechanical, including photocopying, recording, or by any information storage and retrieval system without express written permission from RFXCOM.

 

//----------------------------------------------------------------------------

//                     Software License Agreement                     

//                                                                    

// Copyright 2011-2013, RFXCOM

//

// ALL RIGHTS RESERVED. This code is owned by RFXCOM, and is protected under

// Netherlands Copyright Laws and Treaties and shall be subject to the

// exclusive jurisdiction of the Netherlands Courts. The information from this

// file may freely be used to create programs to exclusively interface with

// RFXCOM products only. Any other use or unauthorized reprint of this material

// is prohibited. No part of this file may be reproduced or transmitted in

// any form or by any means, electronic or mechanical, including photocopying,

// recording, or by any information storage and retrieval system without

// express written permission from RFXCOM.

//

// The above copyright notice shall be included in all copies or substantial

// portions of this Software.

//-----------------------------------------------------------------------------

"""

import logging
from .parserlibs import (my_fctname,coroutine,db2dict,header,updtnewdetector)
from .rfxtrxlibs import *

logger = logging.getLogger()



@my_fctname
@coroutine
def tdetdecoder(targets,rejected=None,newids=None,rawevt=None):
    """
    Decoder for X10 RF secured
    """
    ids = db2dict('DETECTORIDS')
    rows = RFXTRXDECODERS
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, type, subtype, data, p, protocol, revt, decrow = msgs
        if protocol != 'x10s' : continue
       	logger.debug("Protocol %s type %s subtype %s",protocol, type, subtype)
        if decrow in rows:
            row = rows[decrow]
        else:
            if rejected: rejected.send(['DECODER_NOT_IMPLEMENTED',protocol] + msgs)
            continue
       	try:
       	    res = eval(row[1])
       	except Exception as e:
       	    logger.error("Exception / Error %s",repr(e))
       	    if rejected: rejected.send(['ERR_DECODE',repr(row[1])] + msgs)
       	    continue
       	logger.debug("Result %s",repr(res))
       	addrid,status,rssi = res[0:3]
        event = None
        #Detector Unit / Id
        V = (protocol,addrid)
        if V in ids:
            s = ids[V]
            logger.debug("DetectorId Row %s",repr(s))
            decevt = [protocol,addrid,status]
            event = header(namedev) + decevt
            for target in targets:
                logger.debug("Function tdetdecoder for %s",repr(event))
                target.send(event)
            if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])
        else:
            logger.debug("New detector Id %s", addrid)
            if newids: ids = updtnewdetector([protocol,addrid,type,subtype])

