# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

"""
Company Telldus Technologies
----------------------------
- Website: http://www.telldus.com
- Documentation and source code TelldusDuo is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from Telldus Sofware
  * piHAparsers/tsduolibs
"""

import logging,sys
logger = logging.getLogger()

# From rfcmd createNexaString
def nexa2cmd(args):
    houseunit,onoff,level = args
    hc = ord(houseunit[0].upper()) - 65	# house = 'A'
    uc = int(houseunit[1:]) - 1		# unit  = '1'
    if onoff == 'OFF':
        oc = 0
    else:
        oc = 1
    ic = hc
    ic |= (uc << 4)
    ic |= (0x6 << 8)
    ic |= (oc << 11)
    bitmask = 0x0001
    cmd = "S"
    for i in range(0,12):
        if (bitmask & ic) == 0:
            cmd += " ` `"
        else:
            cmd += " `` "
        bitmask = bitmask<<1
    cmd += " }+"
    return cmd
