PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE detectorIds (
  rowId INTEGER PRIMARY KEY NOT NULL,
  cdate TEXT DEFAULT '2013-10-01',
  ctime TEXT DEFAULT '00:00:00',
  detectorId TEXT NOT NULL UNIQUE,
  iddecoder TEXT NOT NULL DEFAULT 'x10s',
  idencoder TEXT NOT NULL DEFAULT 'X10S',
  unit TEXT NOT NULL DEFAULT 'D0',
  active TEXT NOT NULL DEFAULT 'True',
  label TEXT NOT NULL DEFAULT 'NO LABEL'
);
CREATE TABLE deviceIds (
  rowId INTEGER PRIMARY KEY NOT NULL,
  cdate TEXT DEFAULT '2013-10-01',
  ctime TEXT DEFAULT '00:00:00',
  deviceId TEXT NOT NULL UNIQUE,
  iddecoder TEXT NOT NULL DEFAULT '',
  idencoder TEXT NOT NULL DEFAULT '',
  active TEXT NOT NULL DEFAULT 'True',
  unit TEXT NOT NULL DEFAULT 'A0',
  label TEXT NOT NULL DEFAULT 'NO LABEL'
);
CREATE TABLE sensorIds (
  rowId INTEGER PRIMARY KEY NOT NULL,
  modelId TEXT NOT NULL DEFAULT 'modelId',
  iddecoder TEXT NOT NULL DEFAULT 'oregon',
  sensorId TEXT NOT NULL DEFAULT 'sensorId',
  active TEXT NOT NULL DEFAULT 'True',
  unit TEXT NOT NULL DEFAULT 'P0',
  cdate TEXT DEFAULT '2013-10-01',
  ctime TEXT DEFAULT '00:00:00',
  label TEXT NOT NULL DEFAULT 'NO LABEL'
);
CREATE TABLE labeldevice(label TEXT,type TEXT,stype TEXT);
INSERT INTO "labeldevice" VALUES('OWL CM119/160','0x5a','0x01');
INSERT INTO "labeldevice" VALUES('OWL CM180','0x5a','0x02');
INSERT INTO "labeldevice" VALUES('THR128/138,THC138','0x50','0x01');
INSERT INTO "labeldevice" VALUES('THC238/268,THN132,THWR288,THRN122,THN122,AW129/131','0x50','0x02');
INSERT INTO "labeldevice" VALUES('THWR800','0x50','0x03');
INSERT INTO "labeldevice" VALUES('RTHN318','0x50','0x04');
INSERT INTO "labeldevice" VALUES('La Crosse TX2, TX3, TX4, TX17','0x50','0x05');
INSERT INTO "labeldevice" VALUES('TS15C','0x50','0x06');
INSERT INTO "labeldevice" VALUES('Viking 02811','0x50','0x07');
INSERT INTO "labeldevice" VALUES('La Crosse WS2300','0x50','0x08');
INSERT INTO "labeldevice" VALUES('RUBiCSON','0x50','0x09');
INSERT INTO "labeldevice" VALUES('TFA 30.3133','0x50','0x0a');
INSERT INTO "labeldevice" VALUES('X10 lighting','0x10','0x00');
INSERT INTO "labeldevice" VALUES('ARC Code Wheel : KlikAanKlikUit, NEXA, CHACON, HomeEasy, Proove, DomiaLite, InterTechno, AB600','0x10','0x01');
INSERT INTO "labeldevice" VALUES('ARC Self Learning','0x11','0x00');
INSERT INTO "labeldevice" VALUES('HomeEasy EU','0x11','0x01');
INSERT INTO "labeldevice" VALUES('ANSLUT','0x11','0x02');
INSERT INTO "labeldevice" VALUES('PT2262','0x13','0x00');
INSERT INTO "labeldevice" VALUES('LightwaveRF, Siemens','0x14','0x00');
INSERT INTO "labeldevice" VALUES('BBSB new types','0x14','0x02');
INSERT INTO "labeldevice" VALUES('Conrad RSL2','0x14','0x04');
INSERT INTO "labeldevice" VALUES('Blyss','0x15','0x00');
INSERT INTO "labeldevice" VALUES('Blinds1','0x19','0x00');
INSERT INTO "labeldevice" VALUES('X10 security door/window sensor','0x20','0x00');
INSERT INTO "labeldevice" VALUES('X10 security motion sensor','0x20','0x01');
INSERT INTO "labeldevice" VALUES('X10 security remote (no alive packets)','0x20','0x02');
INSERT INTO "labeldevice" VALUES('KD101 (no alive packets)','0x20','0x03');
INSERT INTO "labeldevice" VALUES('Visonic PowerCode door/window sensor – primary contact (with alive packets)','0x20','0x04');
INSERT INTO "labeldevice" VALUES('Visonic PowerCode motion sensor (with alive packets)','0x20','0x05');
INSERT INTO "labeldevice" VALUES('Visonic CodeSecure (no alive packets)','0x20','0x06');
INSERT INTO "labeldevice" VALUES('Visonic PowerCode door/window sensor – auxiliary contact (no alive packets)','0x20','0x07');
INSERT INTO "labeldevice" VALUES('Meiantech','0x20','0x08');
INSERT INTO "labeldevice" VALUES('X10 Ninja Camera','0x28','0x00');
INSERT INTO "labeldevice" VALUES('X10 ATI Remote Wonder','0x30','0x00');
INSERT INTO "labeldevice" VALUES('X10 ATI Remote Wonder Plus','0x30','0x01');
INSERT INTO "labeldevice" VALUES('X10 Medion Remote','0x30','0x02');
INSERT INTO "labeldevice" VALUES('X10 PC Remote','0x30','0x03');
INSERT INTO "labeldevice" VALUES('X10 ATI Remote Wonder II','0x30','0x04');
INSERT INTO "labeldevice" VALUES('Digimax, TLX7506','0x40','0x00');
INSERT INTO "labeldevice" VALUES('Digimax with short format (no set point)','0x40','0x01');
INSERT INTO "labeldevice" VALUES('Mertik G6R-H4T1','0x42','0x00');
INSERT INTO "labeldevice" VALUES('Mertik G6R-H4TB / G6-H4T','0x42','0x01');
INSERT INTO "labeldevice" VALUES('LaCrosse TX3','0x51','0x01');
INSERT INTO "labeldevice" VALUES('LaCrosse WS2300','0x51','0x02');
INSERT INTO "labeldevice" VALUES('THGN122/123, THGN132, THGR122/228/238/268','0x52','0x01');
INSERT INTO "labeldevice" VALUES('THGR810, THGN800, THGR810','0x52','0x02');
INSERT INTO "labeldevice" VALUES('RTGR328','0x52','0x03');
INSERT INTO "labeldevice" VALUES('THGR328','0x52','0x04');
INSERT INTO "labeldevice" VALUES('WTGR800','0x52','0x05');
INSERT INTO "labeldevice" VALUES('THGR918/928, THGRN228, THGN500','0x52','0x06');
INSERT INTO "labeldevice" VALUES('TFA TS34C, Cresta','0x52','0x07');
INSERT INTO "labeldevice" VALUES('WT260,WT260H,WT440H,WT450,WT450H','0x52','0x08');
INSERT INTO "labeldevice" VALUES('Viking 02035,02038 (02035 has no humidity)','0x52','0x09');
INSERT INTO "labeldevice" VALUES('Rubicson','0x52','0x0a');
INSERT INTO "labeldevice" VALUES('BTHR918','0x54','0x01');
INSERT INTO "labeldevice" VALUES('BTHR918N, BTHR968','0x54','0x02');
INSERT INTO "labeldevice" VALUES('RGR126/682/918/928','0x55','0x01');
INSERT INTO "labeldevice" VALUES('PCR800','0x55','0x02');
INSERT INTO "labeldevice" VALUES('TFA','0x55','0x03');
INSERT INTO "labeldevice" VALUES('UPM RG700','0x55','0x04');
INSERT INTO "labeldevice" VALUES('WS2300','0x55','0x05');
INSERT INTO "labeldevice" VALUES('La Crosse TX5','0x55','0x06');
INSERT INTO "labeldevice" VALUES('WTGR800','0x56','0x01');
INSERT INTO "labeldevice" VALUES('WGR800','0x56','0x02');
INSERT INTO "labeldevice" VALUES('STR918, WGR918, WGR928','0x56','0x03');
INSERT INTO "labeldevice" VALUES('TFA','0x56','0x04');
INSERT INTO "labeldevice" VALUES('UPM WDS500','0x56','0x05');
INSERT INTO "labeldevice" VALUES('WS2300','0x56','0x06');
INSERT INTO "labeldevice" VALUES('UVN128, UV138','0x57','0x01');
INSERT INTO "labeldevice" VALUES('UVN800','0x57','0x02');
INSERT INTO "labeldevice" VALUES('TFA','0x57','0x03');
INSERT INTO "labeldevice" VALUES('RTGR328N','0x58','0x01');
INSERT INTO "labeldevice" VALUES('CM113, Electrisave, cent-a-meter','0x59','0x01');
INSERT INTO "labeldevice" VALUES('CM180i','0x5b','0x01');
INSERT INTO "labeldevice" VALUES('BWR101/102','0x5d','0x01');
INSERT INTO "labeldevice" VALUES('GR101','0x5d','0x02');


CREATE TABLE alias (
  rowId INTEGER PRIMARY KEY NOT NULL,
  typeunit TEXT NOT NULL DEFAULT 'device',
  label TEXT NOT NULL DEFAULT 'NEW_ALIAS',
  unit TEXT NOT NULL DEFAULT 'NEW_UNIT',
  enabled TEXT NOT NULL DEFAULT 'False'
);



CREATE UNIQUE INDEX sens ON sensorIds(modelId,iddecoder,sensorId);
COMMIT;
