# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,time
from piHAparsers import (Decoders,DecoderNames,Parsers)
from .corelibs import (chkparsdaemon,debug,log2console,log2file,printer)
from .servers import (SetupDaemons)

logger = logging.getLogger()



PostTargets = {
    'DEBUG':debug(),
    'LOG2FILE':log2file('decoded.log'),
    'PRINTER':printer(),
    }


def str2fargs(param,dev):
    p = param.upper()
    if p == 'TRUE': return True
    elif p == 'NONE': return None
    elif p == 'SELF': return dev
    elif p == 'DECREJECTED': return log2file('decoder_rejected.log')
    elif p == 'PARREJECTED': return log2file('parser_rejected.log')
    elif p == 'NEWIDS': return log2file('newids.log')
    elif p == 'RAWEVT': return log2file('rawevt.log','|')


def addparser(params,mctrx=None):
    """
    Add PARSER feature for controller
    params = name:ctrl|argparser
    """
    p = params.split('|')
    p0 = chkparsdaemon(p[0],SetupDaemons)
    if not p0:
        return False
    dev,name,ctrl = p0
    if ctrl[0] == 'N': ctrl = ctrl[1:]
    if mctrx: dev = mctrx
    parsername = ctrl + '-PARSER'
    dev.featurenames.append(parsername)
    args = [dev.decoders]
    if len(p) == 2:
        a = p[1].strip('()') 
        args.append(str2fargs(a,dev))
    print (repr(args))
    parser = Parsers[ctrl]
    dev.features.append(parser(*args))
    print (repr(dev.featurenames))
    print (repr(dev.features))
    return True


def rmparser(params,mctrx=None):
    """
    Remove PARSER from controller feature list
    Reinit all lists
    params = name:ctrl
    """
    p = chkparsdaemon(params,SetupDaemons)
    if not p:
        return False
    dev,name,ctrl = p
    if ctrl[0] == 'N': ctrl = ctrl[1:]
    if mctrx: dev = mctrx
    parser = ctrl + '-PARSER' 
    if parser not in dev.featurenames:
        logger.error('Parser Controller not yet setup %s',parser)
        return False
    i = dev.featurenames.index(parser)
    for decoder in dev.decoders:
        decoder.close()		#Close coroutine generator
    dev.decodernames = []
    dev.decoders = []
    dev.features[i].close()		#Close coroutine generator
    dev.features.pop(i)
    dev.featurenames.remove(parser)
    logger.info("Parser %s removed for controller %s",parser,ctrl)
    return True


def chkparsdecoder(params,mctrx=None):
    p = params.split('|')
    p0 = chkparsdaemon(p[0],SetupDaemons)
    if not p0:
        return None
    dev,name,ctrl = p0
    if mctrx: dev = mctrx
    if ctrl[0] == 'N': ctrl = ctrl[1:]
    parser = ctrl + '-PARSER' 
    if parser not in dev.featurenames:
        logger.error('Parser Controller not yet setup %s',parser)
        return None
    p1 = p[1].split('(')
    if len(p1) == 0:
        logger.error('A name for decoder is needed')
        return None
    decname = p1[0]
    if decname not in DecoderNames:
        logger.error('Decoder unknown or not implemented %s',decname)
        return None
    if len(p1) == 1: 
        dargs = None
    else:
        dargs = '(' + p1[1]
    return dev,name,ctrl,decname,dargs


def adddecoder(params,mctrx=None):
    """
    Add a decoder to PARSER / DECODER feature
    params = name:ctrl|DECODER(firstarg,secarg)
    parser = ctrl-PARSER
    largs = firstarg,args
    fisrtarg : list of posttargets
    posttargets = [] 
    secarg = second (and third) optionnal arguments
    """
    p = chkparsdecoder(params,mctrx)
    if not p:
        return False
    print (repr(p))
    dev,name,ctrl,decname,dargs = p
    if ctrl[0] == 'N': ctrl = ctrl[1:]
    if mctrx: dev = mctrx
    if decname in dev.decodernames:
        logger.error('Decoder already setup in the list of controller')
        return False
    largs = dargs[2:-1].split(']')
    firstarg = largs[0]
    listpts = [printer()]
    if len(firstarg) != 0:
        for pt in firstarg.split(','):
            if pt in PostTargets:
                listpts.append(PostTargets[pt])
            else:
                logger.error('Posttarget %s unknown',pt)
                return False
    args = [listpts]
    if len(largs[1]) > 1:
        secarg = largs[1][1:].split(',')
        for a in secarg:
            args.append(str2fargs(a,dev))
    logger.debug('Posttargets for decoder %s',repr(listpts))
    logger.debug('Arguments for decoder %s',repr(args))
    decoder = DecoderNames[decname]
    if decoder in Decoders[ctrl]:
        try:
            fct = decoder(*args)
            dev.decoders.append(fct)
            dev.decodernames.append(decname)
            logger.info('Decoders setup %s for controller',repr(dev.decoders))
            return True
        except Exception as e:
            logger.error("%s : %s", repr(e.__class__), str(e))
            logger.error("In adding Feature %s to server %s" ,feature,dev.name)
            return False
    else:
        logger.error('Decoder %s not implemented for the controller %s',decname,ctrl)
        return False


def rmdecoder(params,mctrx=None):
    """
    remove a decoder from PARSER / DECODER feature
    params = name:ctrl|DECODER
    parser = ctrl-PARSER
    """
    p = chkparsdecoder(params)
    if not p:
        return False
    dev,name,ctrl,decname,dargs = p
    if mctrx: dev = mctrx
    if decname not in dev.decodernames:
        logger.error("Decoder %s not in server decoders list %s",decname,repr(dev.decodernames))
        return False
    i = dev.decodernames.index(decname)
    dev.decoders[i].close()
    dev.decoders.pop(i)
    print (repr(dev.decoders))
    dev.decodernames.remove(decname)
    logger.info("Decoder %s removed for controller %s",decname,ctrl)
    return True

