# ----------------------------------------------------------------------------
#       Copyright 2013 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging,os.path,sqlite3
from .conflibs import confgetval

logger = logging.getLogger()


def dumprows(rows):
    msg = []
    for row in rows:
        ln = []
        for r in row:
            ln.append(repr(r))                
        msg.append('|'.join(ln))
    return msg


def huorhexid(item):
    if len(item) == 2:	#houseunit : => upper
        return item.upper()
    return item.lower()	#hexid : => lower


def initdbconn():
    DefaultDB3 = confgetval('pimucha.conf','SqliteDB','ConfigDB','dbase.db3')
    conn = sqlite3.connect(DefaultDB3, check_same_thread=False)
    conn.text_factory = str
    return conn
DefaultCONN = initdbconn()


ListReplicateDb = []
def majdb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    conn.commit()
    for db in ListReplicateDb:
        try:
             conn1 = sqlite3.connect(db)
             cur = conn1.cursor()
             cur.execute(req,data)
             conn1.commit()
             conn1.close()
        except:
             pass


def ralldb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    rows = cur.fetchall()
    return rows


def reqdb3(req,data):
    conn = DefaultCONN
    cur = conn.cursor()
    cur.execute(req,data)
    row = cur.fetchone()
    return row


FctDb2Dict = {
    'DETECTORIDS':["SELECT iddecoder,detectorId,idencoder FROM detectorIds ","((rows[i][0],rows[i][1]),rows[i][2])"],
    'DETECTORSTATE':["SELECT addressId,rowId,cstatus,cdate,ctime FROM detectorstate ","(rows[i][0],rows[i][1:])"],
    'DEVICEIDS':["SELECT iddecoder,deviceId,idencoder FROM deviceIds ","((rows[i][0],rows[i][1]),rows[i][2:])"],
    'SENSORIDS':["SELECT iddecoder,modelId,sensorId,unit FROM sensorIds ","(rows[i][0:3],rows[i][3])"],
    'LAUNCHCMD':["SELECT rxdata,rowId,label,delay,action,data FROM launchcmd ","(rows[i][0],rows[i][1:])"],
    'LAUNCHEVAL':["SELECT DISTINCT rxctrl,rxdevice,rxeval FROM launchcmd ","(rows[i][0:2],rows[i][2])"],
    'LAUNCHLAST':["SELECT rowId,lastime FROM launchcmd ","(rows[i][0],rows[i][1])"],
    }


def db2dict(cnxfct,condition=None):
    logger.debug("Request Sqlite for %s",cnxfct)
    if condition :
        req = FctDb2Dict[cnxfct][0] + condition
    else:
        req = FctDb2Dict[cnxfct][0]
    pair = FctDb2Dict[cnxfct][1]
    rows = ralldb3(req,'')
    a =[]
    for i in range(0,len(rows)):
         a.append(eval(pair))
    return dict(a)



def updtnewdetector(item):
    #item = [protocol,addrid]
    #item = [protocol,addrid,type,subtype]
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    label = 'NO LABEL'
    if len(item) == 4:
        label =  labelofdev(item[2],item[3])
    try:
        req = "INSERT INTO detectorIds(cdate,ctime,iddecoder,detectorId,unit,label) VALUES (?,?,?,?,?,?);"
        majdb3(req,[d[0], d[1], item[0], item[1], item[1], label])
        req = "INSERT INTO alias(label,unit,typeunit) VALUES (?,?,?);"
        majdb3(req,[item[1],item[1],'detector'])
        req = "INSERT INTO detectorstate(unit) VALUES (?);"
        majdb3(req,[item[1],])
    except Exception as e:
        logger.debug("Update failed for newids with error : %s",repr(e))
    return db2dict('DETECTORIDS')


def updtnewdevice(item):
    #item = [protocol,hu]
    #item = [protocol,hu,type,subtype]
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    label = 'NO LABEL'
    if len(item) == 4:
        label =  labelofdev(item[2],item[3])
    try:
        hu = huorhexid(item[1])
        req = "INSERT INTO deviceIds(cdate,ctime,iddecoder,deviceId,unit,label) VALUES (?,?,?,?,?,?);"
        majdb3(req,[d[0], d[1], item[0],hu,hu,label])
        req = "INSERT INTO alias(label,unit,typeunit) VALUES (?,?,?);"
        majdb3(req,[label,hu,'device'])
    except Exception as e:
        logger.debug("Update failed for newids with error : %s",repr(e))
    return db2dict('DEVICEIDS')


def updtnewsensor(item):
    #item =  [protocol, model, addr,row[0],type,subtype]
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    label =  labelofdev(item[4],item[5])
    listdata = item[3].split()
    try:
        req = "INSERT INTO sensorIds(cdate,ctime,iddecoder,modelId,sensorId,unit,label) VALUES (?,?,?,?,?,?,?);"
        unit = item[1] + '_' + item[2]
        majdb3(req,[d[0], d[1],item[0],item[1],item[2],unit,label])
        for ld in listdata:
            pu = ld + '_' + unit
            req = "INSERT INTO alias(label,unit,typeunit) VALUES (?,?,?);"
            majdb3(req,[pu,pu,'sensor'])
            req = "INSERT INTO sensorstate(param_unit) VALUES (?);"
            majdb3(req,[pu,])
    except Exception as e:
        logger.debug("Update failed for newids with error : %s",repr(e))
    return db2dict('SENSORIDS')


def labelofdev(type,subtype):
    req = "SELECT label FROM labeldevice WHERE type = ? AND stype = ?;"
    r = reqdb3(req,[type,subtype])
    if r:
        return r[0]
    else:
        return 'NO LABEL'
