# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time

from .coredecoders import (adddecoder,rmdecoder,addparser,rmparser)
from .corelibs import (adstr2addr,confgetval,sysevents,lst2lines,startscriptexe)
from .coresetup import (
     mctrx,setupctrl,setupnetctrl,setupsrv,
     startsrv,stopsrv,stopallctrls,
     Servers,SetupDaemons,SetupControllers,
     )
from .parsecmds import ParseCMDS
from .rpccmds import RPCFunctions
from .rpclcmds import RPCLocalFunctions

logger = logging.getLogger()

STARTScript = confgetval('pimucha.conf','FilesPath','STARTScript','startscript/')
SYSLogfile = confgetval('pimucha.conf','ServersArgs','SYSLogfile','sysevents.log')
RPCSAddport = confgetval('pimucha.conf','ServersArgs','RPCSAddport','')
TCPRXAddport = confgetval('pimucha.conf','ServersArgs','TCPRXAddport','')
TCPSAddport = confgetval('pimucha.conf','ServersArgs','TCPSAddport','')


def runscript(script):
    thefile = STARTScript + script.lower() + '.scr'
    lines = lst2lines(thefile)
    if not lines:
        return False
    print('Executing %s...' % thefile)
    p = threading.Thread(target=startscriptexe, args=(SetupDaemons['SYSLOGF'],lines,))
    p.__name__ = 'ThreadSTARTscript_' + 'script'
    p.daemon = True
    p.start()
    return True


def startalls(trx=True,ttx=True):
    if RPCSAddport !=  '':
        if RPCSAddport == 'Defaults':
            rpcs = Servers['RPCS']()
            rpcs.Functions += RPCFunctions
            rpcs.Functions += RPCLocalFunctions
        else:
            rpcs = Servers['RPCS'](adstr2addr(RPCSAddport))
            rpcs.Functions += RPCFunctions
        rpcs.tsetup()
        rpcs.starts()
        SetupDaemons.setdefault('RPCS')
        SetupDaemons['RPCS'] = rpcs

    if trx and TCPRXAddport !=  '':
        if TCPRXAddport == 'Defaults':
            tcprx = Servers['TCPRX']()
        else:
            tcprx = Servers['TCPRX'](adstr2addr(TCPRXAddport))
        tcprx.tsetup()
        tcprx.starts()
        SetupDaemons.setdefault('TCPRX')
        SetupDaemons['TCPRX'] = tcprx

    if ttx and TCPSAddport !=  '':
        if TCPSAddport == 'Defaults':
            tcps = Servers['TCPS']()
        else:
            tcps = Servers['TCPS'](adstr2addr(TCPSAddport))
        tcps.tsetup()
        tcps.starts()
        SetupDaemons.setdefault('TCPS')
        SetupDaemons['TCPS'] = tcps


def startsysf(daemon=True):
    syslogf = Servers['SYSLOGF'](SYSLogfile)
    syslogf.features.append(sysevents(AdminCmds))
    syslogf.tsetup()
    if not syslogf.setup : return False
    syslogf.starts(daemon)
    SetupDaemons.setdefault('SYSLOGF')
    SetupDaemons['SYSLOGF'] = syslogf

    inparser = Servers['INParser']()
    inparser.Functions.update(ParseCMDS)
    inparser.tsetup()
    inparser.starts()
    SetupDaemons.setdefault('INParser')
    SetupDaemons['INParser'] = inparser
    return True


AdminCmds = {
    'ADDDecoder':adddecoder,
    'ADDParser':addparser,
    'MCTRX':mctrx,
    'RMDecoder':rmdecoder,
    'RMParser':rmparser,
    'SETUPctrl':setupctrl,
    'SETUPnetctrl':setupnetctrl,
    'SETUPsrv':setupsrv,
    'STARTsrv':startsrv,
    'STOPall':stopallctrls,
    'STOPsrv':stopsrv,
    'RUNscript':runscript,
    }
