# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading
from .corelibs import (newalias,alias2hu,huoralias,hu2alias,hudevice,lsdev)
from .servers import (SetupDaemons)

logger = logging.getLogger()

RPCLocalFunctions = []


def alias_rpc(param):
    if not param:
        return lsdev('ALIAS')
    a = param.split()
    if len(a) == 1:
        hu = huoralias(param)
        if hu:
            if hu == param:
                return hu2alias(hu) + ' : ' + param
            else:
                return param + ' : ' + alias2hu(param)
        else:
            return 'NoAlias' + ' : ' + param
    else:
        return newalias(['newalias'] + a)
RPCLocalFunctions.append((alias_rpc, 'alias'))


def infos_rpc(params):
    print (repr(TXControllers))
    print (repr(SetupDaemons))
    print (repr(threading.enumerate()))
    return True
RPCLocalFunctions.append((infos_rpc, 'infos'))


def lsdev_rpc(param):
    return lsdev(param)
RPCLocalFunctions.append((lsdev_rpc, 'lsdev'))


def stops_rpc(params):
    if params in SetupDaemons:
        SetupDaemons[params].stops()
        res = ('STOPPING %s...' % params)
        del SetupDaemons[params]
    else:
        res = 'Input error'
    return res
RPCLocalFunctions.append((stops_rpc, 'stops'))

