"""
Software PYRFXCOM Author
------------------------
- Website: https://github.com/barnybug/pyrfxcom/
- PYRFXCOM is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from PYRFXCOM
  * piHAparsers/orelibs
"""

def h2s(x):
    return ' '.join([ '0x%02x' % ord(y) for y in x.decode('hex') ])

def hi_nibble(x):
    return x >> 4

def lo_nibble(x):
    return x & 0xf

def nibble_sum(c, y):
    s = 0
    for i in range(0, c):
        s += hi_nibble(y[i])
        s += lo_nibble(y[i])
    if int(c) != c:
        s += hi_nibble(y[c])
    return s

def n_s(s,e, y):
    sum = 0
    for i in range(s,e):
        sum += lo_nibble(y[i]) + hi_nibble(y[i])
    return sum

def dec_byte(p, n):
    return hi_nibble(p[n]) * 10 + lo_nibble(p[n])
