# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time

from piHAlibs import (confgetval)
from .corelibs import (lst2lines,startscriptexe,shellexe)
from .coresetup import (SetupDaemons,
    setupctrl,setupnetctrl,setupsrv,
    startsrv,stopsrv,stopallctrls,
    )
from .coremctrx import (mctrx)
from .decoders import (adddecoder,rmdecoder,addparser,rmparser)
from .rpclcmds import (RPCLocalFunctions)
from .usercmds import (UserCmds)

logger = logging.getLogger()


def runscript(param):
    if isinstance(param,list):
        script = param[0]
    else:
        script = param
    pscript = confgetval('pimucha.conf','FilesPath','STARTScript','startscript/')
    thefile = pscript + script.lower() + '.scr'
    lines = lst2lines(thefile)
    if not lines:
        return False
    print('Executing %s...' % thefile)
    p = threading.Thread(target=startscriptexe, args=(SetupDaemons['SYSLOGF'],lines,))
    p.__name__ = 'ThreadSTARTscript_' + 'script'
    p.daemon = True
    p.start()
    return True
RPCLocalFunctions.append((runscript,'run'))


AdminCmds = {
    'ADDDecoder':adddecoder,
    'ADDParser':addparser,
    'MCTRX':mctrx,
    'RMDecoder':rmdecoder,
    'RMParser':rmparser,
    'SETUPctrl':setupctrl,
    'SETUPnetctrl':setupnetctrl,
    'SETUPsrv':setupsrv,
    'STARTsrv':startsrv,
    'STOPall':stopallctrls,
    'STOPsrv':stopsrv,
    'RUN':runscript,
    'SHELL' : shellexe,
    }
AdminCmds.update(UserCmds)
