# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from .decoders import (addparser,adddecoder)
from .multictrx import MULTICTRX
from .servers import (SetupDaemons,SetupControllers)

logger = logging.getLogger()


def mctrx(param):
    """
    param = [subcmd,arg]
    param = ['INIT',name]
          First step : Name to identify MCTRX
    param = ['PARSER',daemon]
          Second step : add already setup RX controllers to MCTRX and parser
          daemon = namedaemon:controller
    param = ['DECODER',decoder]
          Third step : add decoder with args to parser
    param = ['STARTM']
          Last step : start MCTRX controller
    """
    if len(param) == 0: return False
    if param[0] not in ('INIT','PARSER','DECODER','STARTM'): return False
    if param[0] == 'INIT':
        if len(param) < 2: return False
        namedev = param[1] + ':MCTRX'
        if 'MCTRX' in SetupDaemons:
            print ('A  MULTICTRX controller is already setup, only one MCTRX can be setup for process')
            return False
        else:
            #Init 
            try:
                dev = MULTICTRX()
                dev.name = namedev
                SetupDaemons.setdefault('MCTRX')
                SetupDaemons['MCTRX'] = dev
                return True
            except Exception as e:
                logger.critical("%s : %s", repr(e.__class__), str(e))
                print ('Error in init daemon for %s' % namedev)
                return False
    else:
        if 'MCTRX' in SetupDaemons:
            dev = SetupDaemons['MCTRX']
        else:
            logger.error('MULTICTRX controller is not yet setup')
            return False
    #Add an already setup RX controller
    if param[0] == 'PARSER':
        if len(param) < 2: return False
        namectrl = param[1]
        if namectrl in dev.rxctrls:
            logger.error('Controller %s is already affected to MULTICTRX controller',namectrl)
            return False
        if namectrl in SetupControllers:
            dev.rxctrls.setdefault(namectrl)
            dev.rxctrls[namectrl] = SetupControllers[namectrl]
            logger.debug('Controller %s affected to MULTICTRX',repr(dev.rxctrls))
            rxname,rxctrl = namectrl.split(':')
            res = addparser(namectrl,dev)
            if res :
                logger.debug('Parser %s added to MULTICTRX',repr(dev.features))
                return True
            else:
                logger.error('Error in adding parser %s to MULTICTRX',namectrl)
                return False
        else:
            logger.error('An RX controller already setup is needed')
            return False
    #Add decoder to parser
    if param[0] == 'DECODER':
        if len(param) < 2: return False
        p = param[1]
        namectrl,dargs = p.split('-')
        if namectrl == p:
            logger.error('Syntax error with decoder')
            return False
        if namectrl not in dev.rxctrls:
            logger.error('%s controller and parser not yet affected to MULTICTRX controller',namectrl)
            return False
        res = adddecoder(namectrl + '|' + dargs,dev)
        if res:
            logger.debug('Decoder %s added to MULTICTRX',repr(dargs))
            return True
        else:
            logger.error('Error in adding decoder %s to MULTICTRX',repr(dargs))
            return False
    #Start MULTICTRX
    if param[0] == 'STARTM':
        dev.tsetup()
        if dev.setup:
            dev.startm()
            print ('Daemon of MULTICTRX correctly started : %s' % repr(dev))
            return True
        else:
            print ('Error in setup Daemon of MULTICTRX %s' % param)
            return False
    #Stop MULTICTRX
    if param == 'STOPS':
        if dev.setup:
            dev.stops()
            print ('Daemon of MULTICTRX correctly stopped')
            return True
        else:
            print ('Daemon of MULTICTRX is not yet setup and started %s' % repr(dev))
            return False
    else:
        print ('Syntax error %s' % param)
        return False
